/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Optional;
import mods.railcraft.api.core.BlockEntityLike;
import mods.railcraft.api.core.NetworkSerializable;
import mods.railcraft.api.signal.SignalNetwork;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSignalNetwork<T extends BlockEntityLike>
implements SignalNetwork<T>,
ValueIOSerializable,
NetworkSerializable {
    private final Class<T> peerType;
    private final int maxPeers;
    private final Runnable syncListener;
    protected final Deque<BlockPos> peers = new ArrayDeque<BlockPos>();
    private final Collection<BlockPos> unmodifiablePeers = Collections.unmodifiableCollection(this.peers);
    private boolean linking;

    public AbstractSignalNetwork(Class<T> peerType, Runnable syncListener) {
        this(peerType, -1, syncListener);
    }

    public AbstractSignalNetwork(Class<T> peerType, int maxPeers, Runnable syncListener) {
        this.peerType = peerType;
        this.maxPeers = maxPeers;
        this.syncListener = syncListener;
    }

    public abstract Level getLevel();

    @Override
    public Optional<T> peerAt(BlockPos blockPos) {
        return this.peers.contains(blockPos) ? Optional.ofNullable(this.getBlockEntity(blockPos)) : Optional.empty();
    }

    @Nullable
    protected T getBlockEntity(BlockPos blockPos) {
        BlockEntity blockEntity = this.getLevel().getBlockEntity(blockPos);
        return (T)(this.peerType.isInstance(blockEntity) && !blockEntity.isRemoved() ? (BlockEntityLike)this.peerType.cast(blockEntity) : null);
    }

    @Override
    public Collection<BlockPos> peers() {
        return this.unmodifiablePeers;
    }

    @Override
    public boolean addPeer(T peer) {
        if (this.peers.contains(peer.asBlockEntity().getBlockPos())) {
            return false;
        }
        BlockPos peerPos = peer.asBlockEntity().getBlockPos();
        this.peers.add(peerPos);
        if (this.maxPeers > -1 && this.peers.size() > this.maxPeers) {
            this.removePeer(this.peers.peek());
        }
        this.syncToClient();
        return true;
    }

    @Override
    public void destroy() {
        ArrayList<BlockPos> peers = new ArrayList<BlockPos>(this.peers);
        for (BlockPos peerPos : peers) {
            this.removePeer(peerPos);
        }
    }

    @Override
    public void refresh() {
        this.peers.removeIf(peerPos -> this.peerAt((BlockPos)peerPos).filter(this::refreshPeer).isEmpty());
    }

    protected boolean refreshPeer(T peer) {
        return true;
    }

    @Override
    public boolean removePeer(BlockPos peerPos) {
        if (this.peers.remove(peerPos)) {
            this.syncToClient();
            return true;
        }
        return false;
    }

    @Override
    public boolean isLinking() {
        return this.linking;
    }

    @Override
    public void startLinking() {
        this.linking = true;
        this.syncToClient();
    }

    @Override
    public void stopLinking() {
        this.linking = false;
        this.syncToClient();
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.store("peerPos", BlockPos.CODEC.listOf(), new ArrayList<BlockPos>(this.peers));
    }

    public void deserialize(ValueInput valueInput) {
        this.peers.addAll(valueInput.read("peerPos", BlockPos.CODEC.listOf()).orElse(new ArrayList()));
    }

    @Override
    public void writeToBuf(RegistryFriendlyByteBuf data) {
        data.writeBoolean(this.linking);
        data.writeCollection(this.peers, FriendlyByteBuf::writeBlockPos);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        this.linking = data.readBoolean();
        this.peers.clear();
        this.peers.addAll(data.readList(FriendlyByteBuf::readBlockPos));
    }

    public void syncToClient() {
        this.syncListener.run();
    }
}

