/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.charge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import mods.railcraft.charge.ChargeStorageBlockImpl;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;

public final class ChargeSavedData
extends SavedData {
    private static final int ABSENT_VALUE = -1;
    private static final SavedDataType<ChargeSavedData> TYPE = new SavedDataType("railcraft.charge.distribution", ChargeSavedData::new, __ -> RecordCodecBuilder.create(instance -> instance.group((App)Codec.pair((Codec)BlockPos.CODEC.fieldOf("pos").codec(), (Codec)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("value").codec()).listOf().fieldOf("batteries").forGetter(data -> ChargeSavedData.from(data.chargeLevels))).apply((Applicative)instance, ChargeSavedData::new)));
    private final Object2IntMap<BlockPos> chargeLevels = (Object2IntMap)Util.make((Object)new Object2IntOpenHashMap(), map -> map.defaultReturnValue(-1));

    private ChargeSavedData(SavedData.Context context) {
    }

    private ChargeSavedData(List<Pair<BlockPos, Integer>> batteries) {
        for (Pair<BlockPos, Integer> battery : batteries) {
            this.chargeLevels.put((Object)((BlockPos)battery.getFirst()), ((Integer)battery.getSecond()).intValue());
        }
    }

    private static List<Pair<BlockPos, Integer>> from(Object2IntMap<BlockPos> chargeLevels) {
        return chargeLevels.object2IntEntrySet().stream().map(x -> new Pair((Object)((BlockPos)x.getKey()), (Object)x.getIntValue())).toList();
    }

    public void initBattery(ChargeStorageBlockImpl battery) {
        battery.setEnergyStored(this.chargeLevels.computeIfAbsent((Object)battery.getBlockPos(), __ -> battery.getInitialCharge()));
        this.setDirty();
    }

    public void updateBatteryRecord(ChargeStorageBlockImpl battery) {
        this.chargeLevels.put((Object)battery.getBlockPos(), battery.getAmountAsInt());
        this.setDirty();
    }

    public void removeBattery(BlockPos pos) {
        if (this.chargeLevels.removeInt((Object)pos) != -1) {
            this.setDirty();
        }
    }

    public static ChargeSavedData getFor(ServerLevel level) {
        return (ChargeSavedData)level.getDataStorage().computeIfAbsent(TYPE);
    }
}

