/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import java.util.Objects;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.util.GuiUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3x2fStack;

public class IngameWindowScreen
extends Screen {
    public static final ResourceLocation WIDGETS_TEXTURE = RailcraftConstants.rl("textures/gui/widgets.png");
    public static final ResourceLocation LARGE_WINDOW_TEXTURE = RailcraftConstants.rl("textures/gui/large_window.png");
    public static final int TEXT_COLOR = -12566464;
    public static final int DEFAULT_WINDOW_WIDTH = 176;
    public static final int DEFAULT_WINDOW_HEIGHT = 88;
    public static final int LARGE_WINDOW_HEIGHT = 113;
    protected final int windowWidth;
    protected final int windowHeight;
    protected final ResourceLocation backgroundTexture;

    protected IngameWindowScreen(Component title) {
        this(title, WIDGETS_TEXTURE, 176, 88);
    }

    protected IngameWindowScreen(Component title, ResourceLocation backgroundTexture, int windowWidth, int windowHeight) {
        super(title);
        this.windowWidth = windowWidth;
        this.windowHeight = windowHeight;
        this.backgroundTexture = backgroundTexture;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int centredX = (this.width - this.windowWidth) / 2;
        int centredY = (this.height - this.windowHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.backgroundTexture, centredX, centredY, 0.0f, 0.0f, this.windowWidth, this.windowHeight, 256, 256);
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        poseStack.translate((float)centredX, (float)centredY);
        Objects.requireNonNull(this.font);
        GuiUtil.drawCenteredString(guiGraphics, this.font, this.title, this.windowWidth, 9);
        this.renderContent(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.popMatrix();
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void tick() {
        super.tick();
        if (!this.minecraft.player.isAlive() || this.minecraft.player.isDeadOrDying()) {
            this.onClose();
        }
    }
}

