/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.to_server.SetLauncherTrackMessage;
import mods.railcraft.world.level.block.entity.track.LauncherTrackBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class LauncherTrackScreen
extends IngameWindowScreen {
    private final LauncherTrackBlockEntity track;
    private Button minus10Button;
    private Button minus1Button;
    private Button plus1Button;
    private Button plus10Button;

    public LauncherTrackScreen(LauncherTrackBlockEntity track) {
        super((Component)track.getBlockState().getBlock().getName());
        this.track = track;
    }

    public void init() {
        int centredX = (this.width - this.windowWidth) / 2;
        int centredY = (this.height - this.windowHeight) / 2;
        this.minus10Button = Button.builder((Component)Component.literal((String)"-10"), __ -> this.incrementForce(-10)).bounds(centredX + 13, centredY + 50, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.minus10Button);
        this.minus1Button = Button.builder((Component)Component.literal((String)"-1"), __ -> this.incrementForce(-1)).bounds(centredX + 53, centredY + 50, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.minus1Button);
        this.plus1Button = Button.builder((Component)Component.literal((String)"+1"), __ -> this.incrementForce(1)).bounds(centredX + 93, centredY + 50, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.plus1Button);
        this.plus10Button = Button.builder((Component)Component.literal((String)"+10"), __ -> this.incrementForce(10)).bounds(centredX + 133, centredY + 50, 30, 20).build();
        this.addRenderableWidget((GuiEventListener)this.plus10Button);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.minus10Button.active = this.track.getLaunchForce() >= 15;
        this.minus1Button.active = this.track.getLaunchForce() >= 6;
        this.plus1Button.active = this.track.getLaunchForce() < (Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get();
        this.plus10Button.active = this.track.getLaunchForce() <= (Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get() - 10;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentForce = Component.translatable((String)Translations.Screen.LAUNCHER_TRACK_LAUNCH_FORCE, (Object[])new Object[]{this.track.getLaunchForce()});
        GuiUtil.drawCenteredString(guiGraphics, this.font, (Component)componentForce, this.windowWidth, 25);
    }

    private void incrementForce(int incrementAmount) {
        byte force = (byte)Mth.clamp((int)(this.track.getLaunchForce() + incrementAmount), (int)5, (int)((Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get()));
        if (this.track.getLaunchForce() != force) {
            this.track.setLaunchForce(force);
            this.sendAttributes();
        }
    }

    private void sendAttributes() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetLauncherTrackMessage(this.track.getBlockPos(), this.track.getLaunchForce()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

