/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.google.common.collect.Lists;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.RoutingTableBookScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.RailcraftPageButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class RoutingTableBookHelpScreen
extends Screen {
    private final RoutingTableBookScreen routingTableBookScreen;
    private int currentPage;
    private final List<String> pages = Lists.newArrayList();
    private RailcraftPageButton forwardButton;
    private RailcraftPageButton backButton;
    private Component numberOfPages;
    private MultiLineEditBox page;
    private RailcraftButton helpBackButton;

    public RoutingTableBookHelpScreen(RoutingTableBookScreen routingTableBookScreen) {
        super(GameNarrator.NO_TITLE);
        this.routingTableBookScreen = routingTableBookScreen;
        this.numberOfPages = CommonComponents.EMPTY;
        Translations.RoutingTable.MANUAL_PAGES.forEach(s -> this.pages.add(Component.translatable((String)s).getString()));
    }

    private int getNumPages() {
        return this.pages.size();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        this.page = MultiLineEditBox.builder().setShowDecorations(false).setTextColor(-16777216).setCursorColor(-16777216).setShowBackground(false).setTextShadow(false).setX((this.width - 220) / 2 - 7).setY((this.height - 128) / 2 - 10).build(this.font, 220, 150, CommonComponents.EMPTY);
        this.page.setCharacterLimit(1024);
        this.page.setLineLimit(14);
        this.page.setValueListener(s -> this.pages.set(this.currentPage, (String)s));
        this.page.active = false;
        this.addRenderableWidget((GuiEventListener)this.page);
        this.updatePageContent();
        this.numberOfPages = this.getPageNumberMessage();
        this.backButton = (RailcraftPageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 30, yOffset + 150, false, RoutingTableBookScreen.BOOK_LOCATION, button -> this.pageBack()));
        this.forwardButton = (RailcraftPageButton)this.addRenderableWidget((GuiEventListener)new RailcraftPageButton(xOffset + 200, yOffset + 150, true, RoutingTableBookScreen.BOOK_LOCATION, button -> this.pageForward()));
        this.helpBackButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_BACK, button -> this.minecraft.setScreen((Screen)this.routingTableBookScreen), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.width / 2 - 100, this.height / 2 + 90, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing(4);
        layout.addChild((LayoutElement)this.helpBackButton);
        layout.arrangeElements();
        this.updateButtonVisibility();
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.page);
    }

    public Component getNarrationMessage() {
        return CommonComponents.joinForNarration((Component[])new Component[]{super.getNarrationMessage(), this.getPageNumberMessage()});
    }

    private Component getPageNumberMessage() {
        return Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{this.currentPage + 1, this.getNumPages()});
    }

    private void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
            this.updatePageContent();
        }
        this.updateButtonVisibility();
    }

    private void pageForward() {
        if (this.currentPage < this.getNumPages() - 1) {
            ++this.currentPage;
        }
        this.updatePageContent();
        this.updateButtonVisibility();
    }

    private void updatePageContent() {
        this.page.setValue(this.pages.get(this.currentPage), true);
        this.numberOfPages = this.getPageNumberMessage();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < this.getNumPages() - 1;
        this.backButton.visible = this.currentPage > 0;
    }

    public boolean keyPressed(KeyEvent event) {
        switch (event.key()) {
            case 266: {
                this.backButton.onPress((InputWithModifiers)event);
                return true;
            }
            case 267: {
                this.forwardButton.onPress((InputWithModifiers)event);
                return true;
            }
        }
        return super.keyPressed(event);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        int l = this.font.width((FormattedText)this.numberOfPages);
        guiGraphics.drawString(this.font, this.numberOfPages, xOffset - l + 225, yOffset + 15, -16777216, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, RoutingTableBookScreen.BOOK_LOCATION, xOffset, yOffset, 0.0f, 0.0f, 256, 192, 256, 256);
    }
}

