/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import java.util.List;
import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.RoutingTableBookHelpScreen;
import mods.railcraft.client.gui.screen.RoutingTableBookScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.network.to_server.EditRoutingTableBookMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class RoutingTableBookTitleScreen
extends Screen {
    private static final Component EDIT_TITLE_LABEL = Component.translatable((String)"book.editTitle");
    private final RoutingTableBookScreen routingTableBookScreen;
    private final RoutingTableBookHelpScreen helpScreen;
    private final List<String> pages;
    private final InteractionHand hand;
    private final Component ownerText;
    private EditBox titleBox;
    private String titleValue = "";
    private RailcraftButton backButton;
    private RailcraftButton helpButton;

    protected RoutingTableBookTitleScreen(RoutingTableBookScreen routingTableBookScreen, Player owner, InteractionHand hand, List<String> pages) {
        super(GameNarrator.NO_TITLE);
        this.routingTableBookScreen = routingTableBookScreen;
        this.helpScreen = new RoutingTableBookHelpScreen(this.routingTableBookScreen);
        this.hand = hand;
        this.pages = pages;
        this.ownerText = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{owner.getName()}).withStyle(ChatFormatting.DARK_GRAY);
    }

    protected void init() {
        this.backButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_BACK, button -> this.minecraft.setScreen((Screen)this.routingTableBookScreen), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        this.helpButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> this.minecraft.setScreen((Screen)this.helpScreen), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        RailcraftButton doneButton = (RailcraftButton)this.addRenderableWidget((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.GUI_DONE, button -> {
            this.saveChanges();
            this.minecraft.setScreen(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.width / 2 - 100, this.height / 2 + 90, LinearLayout.Orientation.HORIZONTAL);
        layout.spacing(4);
        layout.addChild((LayoutElement)this.backButton);
        layout.addChild((LayoutElement)this.helpButton);
        layout.addChild((LayoutElement)doneButton);
        layout.arrangeElements();
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        this.titleBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, xOffset + 60, yOffset + 50, 114, 20, GameNarrator.NO_TITLE));
        this.titleBox.setMaxLength(15);
        this.titleBox.setBordered(false);
        this.titleBox.setCentered(true);
        this.titleBox.setTextColor(-16777216);
        this.titleBox.setTextShadow(false);
        this.titleBox.setResponder(s -> {
            doneButton.active = !StringUtil.isBlank((String)s);
        });
        this.titleBox.setValue(this.titleValue);
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.titleBox);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void saveChanges() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new EditRoutingTableBookMessage(this.hand, this.pages, Optional.of(this.titleBox.getValue().trim())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.titleBox.isFocused() && !this.titleBox.getValue().isEmpty() && (event.key() == 257 || event.key() == 335)) {
            this.saveChanges();
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(event);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        int l = this.font.width((FormattedText)EDIT_TITLE_LABEL);
        guiGraphics.drawString(this.font, EDIT_TITLE_LABEL, xOffset + 160 - l, yOffset + 34, -16777216, false);
        int l1 = this.font.width((FormattedText)this.title);
        guiGraphics.drawString(this.font, this.title, xOffset + 120 - l1 / 2, yOffset + 50, -16777216, false);
        int l2 = this.font.width((FormattedText)this.ownerText);
        guiGraphics.drawString(this.font, this.ownerText, xOffset + 130 - l2, yOffset + 60, -16777216, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 192) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, RoutingTableBookScreen.BOOK_LOCATION, xOffset, yOffset, 0.0f, 0.0f, 256, 192, 256, 256);
    }
}

