/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import java.util.Optional;
import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.to_server.SetMaintenanceMinecartMessage;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.RailcraftMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public abstract class MaintenanceMinecartScreen<T extends RailcraftMenu>
extends RailcraftMenuScreen<T> {
    protected static final Component PATTERN = Component.translatable((String)Translations.Screen.PATTERN);
    protected static final Component STOCK = Component.translatable((String)Translations.Screen.STOCK);
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final MaintenancePatternMinecart cart;
    private MultiButton<MaintenanceMinecart.Mode> mode;
    private int refreshTimer;

    protected MaintenanceMinecartScreen(T menu, Inventory inventory, Component title, MaintenancePatternMinecart cart) {
        super(menu, inventory, title);
        this.cart = cart;
    }

    protected void init() {
        super.init();
        int centreX = (this.width - this.getXSize()) / 2;
        int centreY = (this.height - this.getYSize()) / 2;
        this.mode = (MultiButton)this.addRenderableWidget((GuiEventListener)((MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.SMALL_BUTTON, this.cart.mode()).bounds(centreX + 120, centreY + this.getYSize() - 100, 40, 16)).stateCallback(this::setMaintenanceMode).tooltipFactory(this::createLockTooltip).build()));
        this.updateButtons();
    }

    private Optional<Tooltip> createLockTooltip(MaintenanceMinecart.Mode mode) {
        return Optional.of(Tooltip.create((Component)Component.translatable((String)mode.getTipsKey())));
    }

    public void containerTick() {
        super.containerTick();
        if (this.refreshTimer++ >= 20) {
            this.updateButtons();
        }
    }

    private void setMaintenanceMode(MaintenanceMinecart.Mode mode) {
        if (mode != this.cart.mode()) {
            this.cart.setMode(mode);
            this.updateButtons();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetMaintenanceMinecartMessage(this.cart.getId(), mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void updateButtons() {
        this.mode.setState(this.cart.mode());
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, PATTERN, 38, 30, -12566464, false);
        guiGraphics.drawString(this.font, STOCK, 125, 25, -12566464, false);
    }
}

