/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.LocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.widget.FluidGaugeRenderer;
import mods.railcraft.client.gui.screen.inventory.widget.GaugeRenderer;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import mods.railcraft.gui.widget.GaugeWidget;
import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.entity.vehicle.locomotive.SteamLocomotive;
import mods.railcraft.world.inventory.SteamLocomotiveMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class SteamLocomotiveScreen
extends LocomotiveScreen<SteamLocomotiveMenu> {
    private static final ResourceLocation TEXTURE_LOCATION = RailcraftConstants.rl("textures/gui/container/steam_locomotive.png");

    public SteamLocomotiveScreen(SteamLocomotiveMenu menu, Inventory inv, Component title) {
        super(menu, inv, title, "steam");
        this.imageHeight = 205;
        this.inventoryLabelY = 110;
        for (Widget w : ((SteamLocomotiveMenu)this.menu).getWidgets()) {
            if (w instanceof FluidGaugeWidget) {
                FluidGaugeWidget fluidGaugeWidget = (FluidGaugeWidget)w;
                this.registerWidgetRenderer(new FluidGaugeRenderer(fluidGaugeWidget));
            }
            if (!(w instanceof GaugeWidget)) continue;
            GaugeWidget gaugeWidget = (GaugeWidget)w;
            this.registerWidgetRenderer(new GaugeRenderer(gaugeWidget));
        }
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return TEXTURE_LOCATION;
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        int x = (this.width - this.getXSize()) / 2;
        int y = (this.height - this.getYSize()) / 2;
        if (((SteamLocomotive)((SteamLocomotiveMenu)this.menu).getLocomotive()).boiler().hasFuel()) {
            int scale = ((SteamLocomotive)((SteamLocomotiveMenu)this.menu).getLocomotive()).boiler().getBurnProgressScaled(12);
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, x + 99, y + 33 - scale, 176.0f, (float)(59 - scale), 14, scale + 2, 256, 256);
        }
    }
}

