/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.detector;

import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.inventory.RailcraftMenuScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.MultiButton;
import mods.railcraft.network.to_server.SetTankDetectorMessage;
import mods.railcraft.world.inventory.detector.TankDetectorMenu;
import mods.railcraft.world.level.block.entity.detector.TankDetectorBlockEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class TankDetectorScreen
extends RailcraftMenuScreen<TankDetectorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = RailcraftConstants.rl("textures/gui/container/tank_detector.png");
    private static final int REFRESH_INTERVAL_TICKS = 20;
    private final TankDetectorBlockEntity tankDetectorBlockEntity;
    private MultiButton<TankDetectorBlockEntity.Mode> mode;
    private int refreshTimer;

    public TankDetectorScreen(TankDetectorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageHeight = 140;
        this.inventoryLabelY = this.imageHeight - 94;
        this.tankDetectorBlockEntity = ((TankDetectorMenu)this.menu).getTankDetectorBlockEntity();
    }

    @Override
    public ResourceLocation getWidgetsTexture() {
        return BACKGROUND_TEXTURE;
    }

    public void init() {
        super.init();
        int centreX = (this.width - this.getXSize()) / 2;
        int centreY = (this.height - this.getYSize()) / 2;
        this.mode = (MultiButton)((MultiButton.Builder)MultiButton.builder(ButtonTexture.LARGE_BUTTON, this.tankDetectorBlockEntity.getMode()).bounds(centreX + 95, centreY + 22, 60, 16)).stateCallback(this::setMode).build();
        this.addRenderableWidget((GuiEventListener)this.mode);
    }

    private void setMode(TankDetectorBlockEntity.Mode mode) {
        if (mode != this.tankDetectorBlockEntity.getMode()) {
            this.tankDetectorBlockEntity.setMode(mode);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetTankDetectorMessage(this.tankDetectorBlockEntity.getBlockPos(), mode), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.refreshTimer++ >= 20) {
            this.mode.setState(this.tankDetectorBlockEntity.getMode());
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)Translations.Screen.FILTER), 50, 29, 0x404040, false);
    }
}

