/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen.inventory.widget;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mods.railcraft.client.gui.screen.inventory.WidgetRenderer;
import mods.railcraft.gui.widget.AnalogGaugeWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class AnalogGaugeRenderer
extends WidgetRenderer<AnalogGaugeWidget> {
    public AnalogGaugeRenderer(AnalogGaugeWidget widget) {
        super(widget);
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        return ((AnalogGaugeWidget)this.widget).getGauge().getTooltip();
    }

    @Override
    public void render(ResourceLocation widgetLocation, final GuiGraphics guiGraphics, int centreX, int centreY, int mouseX, int mouseY) {
        float halfWidth = 1.0f;
        float len = (float)((AnalogGaugeWidget)this.widget).h * 0.75f;
        float value = ((AnalogGaugeWidget)this.widget).getMeasurement();
        float angle = (120.0f * value + 30.0f) * ((float)Math.PI / 180);
        float cosA = Mth.cos((float)angle);
        float sinA = Mth.sin((float)angle);
        final float glx = cosA * len;
        final float gly = sinA * len;
        final float gwx = sinA * halfWidth;
        final float gwy = cosA * halfWidth;
        final float baseOffset = 1.0f / sinA * halfWidth;
        final int color = ARGB.color((int)255, (int)100, (int)0, (int)0);
        float gx = centreX + ((AnalogGaugeWidget)this.widget).x;
        float gy = centreY + ((AnalogGaugeWidget)this.widget).y - 1;
        final float bx = gx + (float)((AnalogGaugeWidget)this.widget).w * 0.5f;
        final float by = gy + (float)((AnalogGaugeWidget)this.widget).h;
        guiGraphics.submitGuiElementRenderState(new GuiElementRenderState(){
            private final Matrix3x2f pose;
            @Nullable
            private final ScreenRectangle scissorArea;
            {
                this.pose = new Matrix3x2f((Matrix3x2fc)guiGraphics.pose());
                this.scissorArea = guiGraphics.peekScissorStack();
            }

            @Nullable
            public ScreenRectangle bounds() {
                ScreenRectangle rectangle = new ScreenRectangle((int)(bx - baseOffset), (int)((float)((int)by) - (gly + gwy)), 2 * (int)baseOffset, 2 * (int)gwy);
                rectangle = rectangle.transformMaxBounds(this.pose);
                return this.scissorArea != null ? this.scissorArea.intersection(rectangle) : rectangle;
            }

            @Nullable
            public ScreenRectangle scissorArea() {
                return this.scissorArea;
            }

            public RenderPipeline pipeline() {
                return RenderPipelines.GUI;
            }

            public TextureSetup textureSetup() {
                return TextureSetup.noTexture();
            }

            public void buildVertices(VertexConsumer vertexConsumer) {
                vertexConsumer.addVertexWith2DPose(this.pose, bx - baseOffset, by).setColor(color);
                vertexConsumer.addVertexWith2DPose(this.pose, bx + baseOffset, by).setColor(color);
                vertexConsumer.addVertexWith2DPose(this.pose, bx - glx + gwx, by - (gly + gwy)).setColor(color);
                vertexConsumer.addVertexWith2DPose(this.pose, bx - glx - gwx, by - (gly - gwy)).setColor(color);
            }
        });
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, widgetLocation, centreX + ((AnalogGaugeWidget)this.widget).ox, centreY + ((AnalogGaugeWidget)this.widget).oy, (float)((AnalogGaugeWidget)this.widget).ou, (float)((AnalogGaugeWidget)this.widget).ov, 4, 3, 256, 256);
    }
}

