/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.particle;

import mods.railcraft.client.particle.SteamParticle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;

public class PumpkinParticle
extends SteamParticle {
    private PumpkinParticle(ClientLevel level, double x, double y, double z, double dx, double dy, double dz, TextureAtlasSprite sprite) {
        super(level, x, y, z, dx, dy, dz, sprite);
        this.gravity = -0.01f;
        this.lifetime = (int)(16.0 / (this.random.nextGaussian() * 0.8 + 0.2));
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.sin((float)(Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime), (float)0.0f, (float)1.0f) * (float)Math.PI));
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz, RandomSource randomSource) {
            return new PumpkinParticle(level, x, y, z, dx, dy, dz, this.spriteSet.get(randomSource));
        }
    }
}

