/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.Optional;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.client.renderer.blockentity.state.AbstractSignalRenderState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSignalRenderer<T extends AbstractSignalBlockEntity, S extends AbstractSignalRenderState>
implements BlockEntityRenderer<T, S> {
    private static final Map<SignalAspect, ResourceLocation> ASPECT_TEXTURE_LOCATIONS = Map.of(SignalAspect.OFF, RailcraftConstants.rl("entity/signal_aspect/off"), SignalAspect.RED, RailcraftConstants.rl("entity/signal_aspect/red"), SignalAspect.YELLOW, RailcraftConstants.rl("entity/signal_aspect/yellow"), SignalAspect.GREEN, RailcraftConstants.rl("entity/signal_aspect/green"));
    private final CuboidModel signalAspectModel = new CuboidModel(1.0f);

    public void extractRenderState(T blockEntity, S renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        ((AbstractSignalRenderState)((Object)renderState)).customName = Optional.ofNullable(((RailcraftBlockEntity)blockEntity).getCustomName());
        ((AbstractSignalRenderState)((Object)renderState)).level = blockEntity.getLevel();
    }

    public void submit(S state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        collector.submitCustomGeometry(poseStack, RenderType.lines(), (pose, vertexConsumer) -> {
            if (state.level != null) {
                BlockEntity blockEntity = state.level.getBlockEntity(state.blockPos);
                if (blockEntity == null) {
                    return;
                }
                SignalAuraRenderUtil.tryRenderSignalAura(blockEntity, pose, vertexConsumer);
            }
        });
        ((AbstractSignalRenderState)((Object)state)).customName.ifPresent(name -> RenderUtil.renderBlockHoverText(collector, state.blockPos, name, poseStack, state.lightCoords));
    }

    protected void renderSignalAspect(S state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState, SignalAspect signalAspect, Direction direction) {
        TextureAtlas textureAtlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        int skyLight = LightTexture.sky((int)((AbstractSignalRenderState)((Object)state)).lightCoords);
        ((AbstractSignalRenderState)((Object)state)).lightCoords = LightTexture.pack((int)signalAspect.getLampLight(), (int)skyLight);
        this.signalAspectModel.clear();
        this.signalAspectModel.setPackedLight(((AbstractSignalRenderState)((Object)state)).lightCoords);
        this.signalAspectModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        this.signalAspectModel.set(direction, this.signalAspectModel.new CuboidModel.Face().setSprite(textureAtlas.getSprite(ASPECT_TEXTURE_LOCATIONS.get((Object)signalAspect))).setSize(16));
        collector.submitCustomGeometry(poseStack, RenderType.entityCutout((ResourceLocation)TextureAtlas.LOCATION_BLOCKS), (pose, vertexConsumer) -> CuboidModelRenderer.render(this.signalAspectModel, pose, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.FRONT, false));
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)(pos.getX() - 1), (double)pos.getY(), (double)(pos.getZ() - 1), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2));
    }
}

