/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.client.renderer.blockentity.AbstractSignalRenderer;
import mods.railcraft.client.renderer.blockentity.state.DualSignalRenderState;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import mods.railcraft.world.level.block.entity.signal.DualSignalBlockEntity;
import mods.railcraft.world.level.block.signal.SignalBlock;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class DualSignalRenderer<T extends AbstractSignalBlockEntity>
extends AbstractSignalRenderer<T, DualSignalRenderState> {
    public DualSignalRenderState createRenderState() {
        return new DualSignalRenderState();
    }

    @Override
    public void extractRenderState(T blockEntity, DualSignalRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        renderState.direction = (Direction)blockEntity.getBlockState().getValue(SignalBlock.FACING);
        renderState.primarySignalAspect = ((AbstractSignalBlockEntity)blockEntity).getPrimarySignalAspect().getDisplayAspect();
        renderState.secondarySignalAspect = ((DualSignalBlockEntity)blockEntity).getSecondarySignalAspect().getDisplayAspect();
    }

    @Override
    public void submit(DualSignalRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        super.submit(state, poseStack, collector, cameraState);
        Direction direction = state.direction;
        poseStack.pushPose();
        double zOffset = -0.175;
        poseStack.translate(zOffset * (double)direction.getStepX(), 0.0, zOffset * (double)direction.getStepZ());
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.19f, 0.0f);
        this.renderSignalAspect(state, poseStack, collector, cameraState, state.primarySignalAspect, direction);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate(0.0f, -0.19f, 0.0f);
        this.renderSignalAspect(state, poseStack, collector, cameraState, state.secondarySignalAspect, direction);
        poseStack.popPose();
        poseStack.popPose();
    }
}

