/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.renderer.blockentity.state.FluidManipulatorRenderState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.manipulator.FluidManipulatorBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public abstract class FluidManipulatorRenderer<T extends FluidManipulatorBlockEntity, S extends FluidManipulatorRenderState>
implements BlockEntityRenderer<T, S> {
    public static final ResourceLocation INTERIOR_TEXTURE_LOCATION = RailcraftConstants.rl("entity/fluid_manipulator/interior");
    private static final CuboidModel interiorModel = new CuboidModel(0.011f, 0.01f, 0.011f, 0.989f, 0.99f, 0.989f);

    public void extractRenderState(T blockEntity, S renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        ((FluidManipulatorRenderState)((Object)renderState)).tank = ((FluidManipulatorBlockEntity)blockEntity).getTankManager().get(0);
    }

    public void submit(S state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        TextureAtlas textureAtlas = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS);
        interiorModel.setAll(interiorModel.new CuboidModel.Face().setSprite(textureAtlas.getSprite(INTERIOR_TEXTURE_LOCATION)));
        interiorModel.setPackedLight(((FluidManipulatorRenderState)((Object)state)).lightCoords);
        interiorModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        collector.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, vertexConsumer) -> CuboidModelRenderer.render(interiorModel, pose, vertexConsumer, -1, CuboidModelRenderer.FaceDisplay.FRONT, true));
        FluidStack fluidStack = ((FluidManipulatorRenderState)((Object)state)).tank.getFluidStack();
        if (fluidStack.getAmount() > 0) {
            float capacity = ((FluidManipulatorRenderState)((Object)state)).tank.getCapacity();
            float level = Math.min((float)fluidStack.getAmount() / capacity, 1.0f);
            float fluidMaxY = fluidStack.getFluidType().isLighterThanAir() ? 1.0f : level;
            CuboidModel model = FluidRenderer.getFluidModel(fluidStack, 0.9921875f, fluidMaxY - 0.0078125f, 0.9921875f, FluidRenderer.FluidType.STILL);
            poseStack.pushPose();
            poseStack.translate(0.00390625f, 0.00390625f, 0.00390625f);
            model.setPackedLight(RenderUtil.calculateGlowLight(((FluidManipulatorRenderState)((Object)state)).lightCoords, fluidStack));
            model.setPackedOverlay(OverlayTexture.NO_OVERLAY);
            collector.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, vertexConsumer) -> CuboidModelRenderer.render(model, pose, vertexConsumer, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true));
            poseStack.popPose();
        }
    }
}

