/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.client.renderer.blockentity.state.TankBlockRenderState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.level.block.entity.tank.TankBlockEntity;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class TankRenderer
implements BlockEntityRenderer<TankBlockEntity, TankBlockRenderState> {
    public boolean shouldRenderOffScreen() {
        return true;
    }

    public boolean shouldRender(TankBlockEntity blockEntity, Vec3 cameraPos) {
        return blockEntity.isMaster() && super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public TankBlockRenderState createRenderState() {
        return new TankBlockRenderState();
    }

    public void extractRenderState(TankBlockEntity blockEntity, TankBlockRenderState renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        float twoPixels = 0.0078125f;
        renderState.fluidMaxX = (float)blockEntity.getMaxX() - 0.0078125f;
        renderState.fluidMaxZ = (float)blockEntity.getMaxZ() - 0.0078125f;
        renderState.maxY = blockEntity.getMaxY();
        renderState.tank = blockEntity.getModule().getTank();
    }

    public void submit(TankBlockRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        FluidStack fluidStack = state.tank.getFluidStack();
        if (fluidStack.isEmpty()) {
            return;
        }
        poseStack.translate(-0.99609375f, 1.0f, -0.99609375f);
        float capacity = state.tank.getCapacity();
        float level = Math.min((float)fluidStack.getAmount() / capacity, 1.0f);
        float fluidMaxY = ((float)state.maxY - 2.0f) * level;
        CuboidModel model = FluidRenderer.getFluidModel(fluidStack, state.fluidMaxX, fluidMaxY, state.fluidMaxZ, FluidRenderer.FluidType.STILL);
        poseStack.pushPose();
        model.setPackedLight(RenderUtil.calculateGlowLight(state.lightCoords, fluidStack));
        model.setPackedOverlay(OverlayTexture.NO_OVERLAY);
        collector.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, vertexConsumer) -> CuboidModelRenderer.render(model, pose, vertexConsumer, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true));
        poseStack.popPose();
    }

    public AABB getRenderBoundingBox(TankBlockEntity blockEntity) {
        return AABB.INFINITE;
    }
}

