/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.client.renderer.entity.cart.StandardMinecartRenderer;
import mods.railcraft.client.renderer.entity.state.RailcraftMinecartRenderState;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionfc;

public abstract class ContentsMinecartRenderer<T extends RailcraftMinecart, S extends RailcraftMinecartRenderState>
extends StandardMinecartRenderer<T, S> {
    public ContentsMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected void renderBody(S renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState, int color) {
        super.renderBody(renderState, poseStack, collector, cameraState, color);
        poseStack.pushPose();
        int displayOffset = ((RailcraftMinecartRenderState)((Object)renderState)).displayOffset;
        float scale = 0.75f;
        poseStack.scale(scale, scale, scale);
        if (!((RailcraftMinecartRenderState)((Object)renderState)).displayBlockState.is(Blocks.AIR)) {
            poseStack.translate(-0.5f, ((float)displayOffset - 8.0f) / 16.0f, 0.5f);
        } else {
            poseStack.translate(-0.5f, ((float)displayOffset - 8.0f) / 16.0f, -0.5f);
        }
        this.renderContents(renderState, poseStack, collector, color);
        poseStack.popPose();
    }

    protected void renderContents(S renderState, PoseStack poseStack, SubmitNodeCollector collector, int color) {
        BlockState blockstate = ((RailcraftMinecartRenderState)((Object)renderState)).displayBlockState;
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            collector.submitBlock(poseStack, blockstate, ((RailcraftMinecartRenderState)((Object)renderState)).lightCoords, OverlayTexture.NO_OVERLAY, ((RailcraftMinecartRenderState)((Object)renderState)).outlineColor);
        }
    }
}

