/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.util.Objects;
import mods.railcraft.client.renderer.entity.state.LocomotiveRenderState;
import mods.railcraft.season.Seasons;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartBehavior;
import net.minecraft.world.entity.vehicle.NewMinecartBehavior;
import net.minecraft.world.entity.vehicle.OldMinecartBehavior;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import org.joml.Quaternionfc;
import org.slf4j.Logger;

public abstract class CustomMinecartRenderer<T extends AbstractMinecart, S extends MinecartRenderState>
extends EntityRenderer<T, S> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public CustomMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void submit(S renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        boolean ghostTrain;
        super.submit(renderState, poseStack, collector, cameraState);
        poseStack.pushPose();
        long i = ((MinecartRenderState)renderState).offsetSeed;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.translate(f, f1, f2);
        if (((MinecartRenderState)renderState).isNewRender) {
            LOGGER.warn("Tried to render a cart with new rendering, but that is not yet implemented");
            this.oldRender(renderState, poseStack, collector, cameraState);
        } else {
            this.oldRender(renderState, poseStack, collector, cameraState);
        }
        float roll = ((MinecartRenderState)renderState).hurtTime;
        if (roll > 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.sin((float)roll) * roll * ((MinecartRenderState)renderState).damageTime / 10.0f * (float)((MinecartRenderState)renderState).hurtDir));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain(renderState)) ? 0.5f : 1.0f;
        this.renderBody(renderState, poseStack, collector, cameraState, ARGB.colorFromFloat((float)(ghostTrain ? 0.8f : 1.0f), (float)colorIntensity, (float)colorIntensity, (float)colorIntensity));
        if (ghostTrain) {
            poseStack.pushPose();
            float scale = 1.1f;
            poseStack.scale(scale, scale, scale);
            this.renderBody(renderState, poseStack, collector, cameraState, ARGB.colorFromFloat((float)0.4f, (float)1.0f, (float)1.0f, (float)1.0f));
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    private void oldRender(S renderState, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        String customName;
        double d0 = ((MinecartRenderState)renderState).x;
        double d1 = ((MinecartRenderState)renderState).y;
        double d2 = ((MinecartRenderState)renderState).z;
        float pitch = ((MinecartRenderState)renderState).xRot;
        float yaw = ((MinecartRenderState)renderState).yRot;
        if (((MinecartRenderState)renderState).posOnRail != null && ((MinecartRenderState)renderState).frontPos != null && ((MinecartRenderState)renderState).backPos != null) {
            Vec3 vector3d1 = ((MinecartRenderState)renderState).frontPos;
            Vec3 vector3d2 = ((MinecartRenderState)renderState).backPos;
            poseStack.translate(((MinecartRenderState)renderState).posOnRail.x - d0, (vector3d1.y + vector3d2.y) / 2.0 - d1, ((MinecartRenderState)renderState).posOnRail.z - d2);
            Vec3 vector3d3 = vector3d2.add(-vector3d1.x, -vector3d1.y, -vector3d1.z);
            if (vector3d3.length() != 0.0) {
                vector3d3 = vector3d3.normalize();
                yaw = (float)(Math.atan2(vector3d3.z, vector3d3.x) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vector3d3.y) * 73.0);
            }
        }
        poseStack.translate(0.0f, 0.375f, 0.0f);
        boolean renderName = false;
        if (((MinecartRenderState)renderState).nameTag != null && !"Ghost Train".equals(customName = ((MinecartRenderState)renderState).nameTag.getString()) && !"Polar Express".equals(customName)) {
            collector.submitNameTag(poseStack, ((MinecartRenderState)renderState).nameTagAttachment, 0, ((MinecartRenderState)renderState).nameTag, false, ((MinecartRenderState)renderState).lightCoords, ((MinecartRenderState)renderState).distanceToCameraSq, cameraState);
            renderName = true;
        }
        if (renderState instanceof LocomotiveRenderState) {
            LocomotiveRenderState locomotiveRenderState = (LocomotiveRenderState)((Object)renderState);
            String dest = locomotiveRenderState.destination;
            if (!StringUtils.isBlank((CharSequence)dest)) {
                poseStack.pushPose();
                if (renderName) {
                    poseStack.translate(0.0f, 0.3f, 0.0f);
                }
                MutableComponent destination = Component.literal((String)dest).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
                collector.submitNameTag(poseStack, ((MinecartRenderState)renderState).nameTagAttachment, 0, (Component)destination, false, ((MinecartRenderState)renderState).lightCoords, ((MinecartRenderState)renderState).distanceToCameraSq, cameraState);
                poseStack.popPose();
            }
        }
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-pitch));
    }

    public void extractRenderState(T entity, S reusedState, float partialTick) {
        super.extractRenderState(entity, reusedState, partialTick);
        MinecartBehavior minecartBehavior = entity.getBehavior();
        if (minecartBehavior instanceof NewMinecartBehavior) {
            NewMinecartBehavior behavior = (NewMinecartBehavior)minecartBehavior;
            CustomMinecartRenderer.newExtractState(entity, behavior, reusedState, partialTick);
            ((MinecartRenderState)reusedState).isNewRender = true;
        } else {
            minecartBehavior = entity.getBehavior();
            if (minecartBehavior instanceof OldMinecartBehavior) {
                OldMinecartBehavior behavior = (OldMinecartBehavior)minecartBehavior;
                CustomMinecartRenderer.oldExtractState(entity, behavior, reusedState, partialTick);
                ((MinecartRenderState)reusedState).isNewRender = false;
            }
        }
        long i = (long)entity.getId() * 493286711L;
        ((MinecartRenderState)reusedState).offsetSeed = i * i * 4392167121L + i * 98761L;
        ((MinecartRenderState)reusedState).hurtTime = (float)entity.getHurtTime() - partialTick;
        ((MinecartRenderState)reusedState).hurtDir = entity.getHurtDir();
        ((MinecartRenderState)reusedState).damageTime = Math.max(entity.getDamage() - partialTick, 0.0f);
        ((MinecartRenderState)reusedState).displayOffset = entity.getDisplayOffset();
        ((MinecartRenderState)reusedState).displayBlockState = entity.getDisplayBlockState();
    }

    private static <T extends AbstractMinecart, S extends MinecartRenderState> void newExtractState(T entity, NewMinecartBehavior behavior, S reusedState, float partialTick) {
        if (behavior.cartHasPosRotLerp()) {
            reusedState.renderPos = behavior.getCartLerpPosition(partialTick);
            reusedState.xRot = behavior.getCartLerpXRot(partialTick);
            reusedState.yRot = behavior.getCartLerpYRot(partialTick);
        } else {
            reusedState.renderPos = null;
            reusedState.xRot = entity.getXRot();
            reusedState.yRot = entity.getYRot();
        }
    }

    private static <T extends AbstractMinecart, S extends MinecartRenderState> void oldExtractState(T entity, OldMinecartBehavior behavior, S reusedState, float partialTick) {
        reusedState.xRot = entity.getXRot(partialTick);
        reusedState.yRot = entity.getYRot(partialTick);
        double d0 = reusedState.x;
        double d1 = reusedState.y;
        double d2 = reusedState.z;
        Vec3 vec3 = behavior.getPos(d0, d1, d2);
        if (vec3 != null) {
            reusedState.posOnRail = vec3;
            Vec3 vec31 = behavior.getPosOffs(d0, d1, d2, (double)0.3f);
            Vec3 vec32 = behavior.getPosOffs(d0, d1, d2, (double)-0.3f);
            reusedState.frontPos = Objects.requireNonNullElse(vec31, vec3);
            reusedState.backPos = Objects.requireNonNullElse(vec32, vec3);
        } else {
            reusedState.posOnRail = null;
            reusedState.frontPos = null;
            reusedState.backPos = null;
        }
    }

    protected abstract void renderBody(S var1, PoseStack var2, SubmitNodeCollector var3, CameraRenderState var4, int var5);
}

