/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import mods.railcraft.client.renderer.entity.cart.CustomMinecartRenderer;
import mods.railcraft.client.renderer.entity.state.LocomotiveRenderState;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.RailcraftMinecart;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.item.DyeColor;

public abstract class LocomotiveRenderer<T extends Locomotive, S extends LocomotiveRenderState>
extends CustomMinecartRenderer<T, S> {
    public LocomotiveRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getPrimaryColor(S loco) {
        return Seasons.isGhostTrain(loco) ? DyeColor.LIGHT_GRAY.getTextureDiffuseColor() : ((LocomotiveRenderState)((Object)loco)).primaryColor;
    }

    protected int getSecondaryColor(S loco) {
        return Seasons.isGhostTrain(loco) ? DyeColor.LIGHT_GRAY.getTextureDiffuseColor() : ((LocomotiveRenderState)((Object)loco)).secondaryColor;
    }

    @Override
    public void extractRenderState(T entity, S reusedState, float partialTick) {
        super.extractRenderState(entity, reusedState, partialTick);
        ((LocomotiveRenderState)((Object)reusedState)).primaryColor = entity.getPrimaryColor();
        ((LocomotiveRenderState)((Object)reusedState)).secondaryColor = entity.getSecondaryColor();
        ((LocomotiveRenderState)((Object)reusedState)).mode = ((Locomotive)entity).getMode();
        ((LocomotiveRenderState)((Object)reusedState)).destination = ((Locomotive)entity).getDestination();
        ((LocomotiveRenderState)((Object)reusedState)).season = ((RailcraftMinecart)entity).getSeason();
    }
}

