/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.model.CubeModel;
import mods.railcraft.client.model.LowSidesMinecartModel;
import mods.railcraft.client.model.RailcraftModelLayers;
import mods.railcraft.client.renderer.entity.cart.ContentsMinecartRenderer;
import mods.railcraft.client.renderer.entity.state.TankMinecartRendererState;
import mods.railcraft.client.util.CuboidModel;
import mods.railcraft.client.util.CuboidModelRenderer;
import mods.railcraft.client.util.FluidRenderer;
import mods.railcraft.client.util.RenderUtil;
import mods.railcraft.world.entity.vehicle.TankMinecart;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.fluids.FluidStack;
import org.joml.Quaternionfc;

public class TankMinecartRenderer
extends ContentsMinecartRenderer<TankMinecart, TankMinecartRendererState> {
    private static final ResourceLocation TANK_TEXTURE_LOCATION = RailcraftConstants.rl("textures/entity/minecart/tank.png");
    private final LowSidesMinecartModel<TankMinecartRendererState> bodyModel;
    private final LowSidesMinecartModel<TankMinecartRendererState> snowModel;
    private final CubeModel<TankMinecartRendererState> tankModel;
    private final ItemModelResolver itemModelResolver;

    public TankMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.bodyModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART));
        this.snowModel = new LowSidesMinecartModel(context.bakeLayer(RailcraftModelLayers.LOW_SIDES_MINECART_SNOW));
        this.tankModel = new CubeModel(RenderType::entityTranslucent, context.bakeLayer(RailcraftModelLayers.CUBE));
        this.itemModelResolver = context.getItemModelResolver();
    }

    @Override
    protected void renderContents(TankMinecartRendererState renderState, PoseStack poseStack, SubmitNodeCollector collector, int color) {
        collector.submitModel(this.tankModel, (Object)renderState, poseStack, this.tankModel.renderType(TANK_TEXTURE_LOCATION), renderState.lightCoords, OverlayTexture.NO_OVERLAY, color, null, 0, null);
        this.renderTank(renderState, poseStack, collector);
        if (renderState.hasFilter) {
            this.renderFilterItem(renderState, poseStack, collector);
        }
    }

    private void renderTank(TankMinecartRendererState renderState, PoseStack poseStack, SubmitNodeCollector collector) {
        StandardTank tank = renderState.tankManager;
        FluidStack fluidStack = tank.getFluidStack();
        float capacity = tank.getCapacity();
        if (capacity > 0.0f && fluidStack.getAmount() > 0) {
            poseStack.pushPose();
            float level = (float)fluidStack.getAmount() / capacity;
            float fluidMaxY = fluidStack.getFluidType().isLighterThanAir() ? 1.0f : Math.min(1.0f, level);
            CuboidModel fluidModel = FluidRenderer.getFluidModel(fluidStack, 0.9921875f, fluidMaxY - 0.0078125f, 0.9921875f, FluidRenderer.FluidType.STILL);
            poseStack.translate(0.00390625f, 0.00390625f, 0.00390625f);
            fluidModel.setPackedLight(RenderUtil.calculateGlowLight(renderState.lightCoords, fluidStack));
            fluidModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
            collector.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, vertexConsumer) -> CuboidModelRenderer.render(fluidModel, pose, vertexConsumer, RenderUtil.getColorARGB(fluidStack, level), CuboidModelRenderer.FaceDisplay.FRONT, true));
            poseStack.popPose();
            if (renderState.isFilling) {
                poseStack.pushPose();
                float size = 0.3f;
                poseStack.translate(0.35f, 0.0f, 0.35f);
                CuboidModel fillingFluidModel = FluidRenderer.getFluidModel(fluidStack, 0.3f, 0.99609375f, 0.3f, FluidRenderer.FluidType.FLOWING);
                fillingFluidModel.setPackedLight(RenderUtil.calculateGlowLight(renderState.lightCoords, fluidStack));
                fillingFluidModel.setPackedOverlay(OverlayTexture.NO_OVERLAY);
                collector.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, vertexConsumer) -> CuboidModelRenderer.render(fillingFluidModel, pose, vertexConsumer, RenderUtil.getColorARGB(fluidStack, 1.0f), CuboidModelRenderer.FaceDisplay.FRONT, true));
                poseStack.popPose();
            }
        }
    }

    private void renderFilterItem(TankMinecartRendererState rendererState, PoseStack poseStack, SubmitNodeCollector collector) {
        poseStack.pushPose();
        float scale = 1.2f;
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        poseStack.translate(0.0f, -0.9f, 0.68f);
        poseStack.scale(1.2f, 1.2f, 1.2f);
        rendererState.itemState.submit(poseStack, collector, rendererState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
        poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(90.0f));
        poseStack.translate(0.0f, -0.9f, 0.68f);
        poseStack.scale(1.2f, 1.2f, 1.2f);
        rendererState.itemState.submit(poseStack, collector, rendererState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    @Override
    protected EntityModel<TankMinecartRendererState> getBodyModel(TankMinecartRendererState cart) {
        return this.bodyModel;
    }

    @Override
    protected EntityModel<TankMinecartRendererState> getSnowModel(TankMinecartRendererState cart) {
        return this.snowModel;
    }

    public TankMinecartRendererState createRenderState() {
        return new TankMinecartRendererState();
    }

    @Override
    public void extractRenderState(TankMinecart entity, TankMinecartRendererState reusedState, float partialTick) {
        super.extractRenderState(entity, reusedState, partialTick);
        reusedState.isFilling = entity.isFilling();
        reusedState.tankManager = entity.getTankManager();
        reusedState.hasFilter = entity.hasFilter();
        this.itemModelResolver.updateForTopItem(reusedState.itemState, entity.getFilterItem().copy(), ItemDisplayContext.GROUND, entity.level(), null, 0);
    }
}

