/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.gametest.instances;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.item.SignalBlockSurveyorItem;
import mods.railcraft.world.level.block.entity.signal.BlockSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;

public class BlockSignalTestInstance
extends GameTestInstance {
    public static final MapCodec<BlockSignalTestInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawnCart").forGetter(t -> t.spawnCart), (App)TestData.CODEC.forGetter(t -> t.info)).apply((Applicative)instance, BlockSignalTestInstance::new));
    private static final BlockPos BLOCK_SIGNAL_LEFT = new BlockPos(7, 1, 3);
    private static final BlockPos BLOCK_SIGNAL_RIGHT = new BlockPos(2, 1, 3);
    private final boolean spawnCart;

    public BlockSignalTestInstance(boolean spawnCart, TestData<Holder<TestEnvironmentDefinition>> info) {
        super(info);
        this.spawnCart = spawnCart;
    }

    public void run(GameTestHelper helper) {
        if (this.spawnCart) {
            helper.spawn(EntityType.MINECART, new BlockPos(5, 1, 2));
        }
        helper.succeedWhen(() -> {
            SignalAspect expectedAspect;
            BlockSignalBlockEntity left = (BlockSignalBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_LEFT, BlockSignalBlockEntity.class);
            BlockSignalBlockEntity right = (BlockSignalBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_RIGHT, BlockSignalBlockEntity.class);
            SignalBlockSurveyorItem.tryLinking(left, right);
            SignalAspect signalAspect = expectedAspect = this.spawnCart ? SignalAspect.RED : SignalAspect.GREEN;
            if (left.getPrimarySignalAspect().equals((Object)expectedAspect) && right.getPrimarySignalAspect().equals((Object)expectedAspect)) {
                helper.succeed();
            } else {
                String expectedText = this.spawnCart ? "Red" : "Green";
                helper.fail((Component)Component.literal((String)"Expected %s on both Signal Block".formatted(expectedText)));
            }
        });
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        if (this.spawnCart) {
            return Component.literal((String)"Block Signal With Cart");
        }
        return Component.literal((String)"Block Signal No Cart");
    }
}

