/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.gametest.instances;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import mods.railcraft.data.gametest.RailcraftGameTestInstances;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.CreativeLocomotive;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.RoutingTableBookContent;
import mods.railcraft.world.level.block.entity.SwitchTrackRouterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RoutingTestInstance
extends GameTestInstance {
    public static final MapCodec<RoutingTestInstance> CODEC = RailcraftGameTestInstances.defaultCodec(RoutingTestInstance::new);
    private static final BlockPos SPAWN_POINT_A = new BlockPos(3, 1, 1);
    private static final BlockPos SPAWN_POINT_B = new BlockPos(5, 1, 1);
    private static final BlockPos SPAWN_POINT_A_B = new BlockPos(7, 1, 1);
    private static final BlockPos SPAWN_POINT_A_C = new BlockPos(9, 1, 1);
    private static final BlockPos TRAIN_A = new BlockPos(12, 1, 16);
    private static final BlockPos TRAIN_B = new BlockPos(12, 1, 5);
    private static final BlockPos TRAIN_A_B = new BlockPos(12, 1, 12);
    private static final BlockPos TRAIN_A_C = new BlockPos(12, 1, 14);

    public RoutingTestInstance(TestData<Holder<TestEnvironmentDefinition>> info) {
        super(info);
    }

    public void run(GameTestHelper helper) {
        ItemStack bookA = new ItemStack((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get());
        RoutingTestInstance.applyBookDest(bookA, "Dest=A");
        ItemStack bookB = new ItemStack((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get());
        RoutingTestInstance.applyBookDest(bookB, "Dest=B");
        ItemStack bookA_B = new ItemStack((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get());
        RoutingTestInstance.applyBookDest(bookA_B, "Dest=A/B");
        ItemStack bookA_C = new ItemStack((ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get());
        RoutingTestInstance.applyBookDest(bookA_C, "Dest=A/C");
        SwitchTrackRouterBlockEntity router_A = (SwitchTrackRouterBlockEntity)helper.getBlockEntity(new BlockPos(9, 1, 6), SwitchTrackRouterBlockEntity.class);
        router_A.setItem(0, bookA);
        SwitchTrackRouterBlockEntity router_B = (SwitchTrackRouterBlockEntity)helper.getBlockEntity(new BlockPos(12, 1, 8), SwitchTrackRouterBlockEntity.class);
        router_B.setItem(0, bookB);
        SwitchTrackRouterBlockEntity router_A_B = (SwitchTrackRouterBlockEntity)helper.getBlockEntity(new BlockPos(8, 1, 12), SwitchTrackRouterBlockEntity.class);
        router_A_B.setItem(0, bookA_B);
        SwitchTrackRouterBlockEntity router_A_C = (SwitchTrackRouterBlockEntity)helper.getBlockEntity(new BlockPos(8, 1, 14), SwitchTrackRouterBlockEntity.class);
        router_A_C.setItem(0, bookA_C);
        CreativeLocomotive train_A = RoutingTestInstance.spawnNewLocomotive(helper, SPAWN_POINT_A, "A");
        CreativeLocomotive train_B = RoutingTestInstance.spawnNewLocomotive(helper, SPAWN_POINT_B, "B");
        CreativeLocomotive train_A_B = RoutingTestInstance.spawnNewLocomotive(helper, SPAWN_POINT_A_B, "A/B");
        CreativeLocomotive train_A_C = RoutingTestInstance.spawnNewLocomotive(helper, SPAWN_POINT_A_C, "A/C");
        helper.runAtTickTime(20L, () -> train_A.setMode(Locomotive.Mode.RUNNING));
        helper.runAtTickTime(60L, () -> train_B.setMode(Locomotive.Mode.RUNNING));
        helper.runAtTickTime(100L, () -> train_A_B.setMode(Locomotive.Mode.RUNNING));
        helper.runAtTickTime(140L, () -> train_A_C.setMode(Locomotive.Mode.RUNNING));
        helper.succeedWhen(() -> {
            helper.assertEntityInstancePresent((Entity)train_A, TRAIN_A);
            helper.assertEntityInstancePresent((Entity)train_B, TRAIN_B);
            helper.assertEntityInstancePresent((Entity)train_A_B, TRAIN_A_B);
            helper.assertEntityInstancePresent((Entity)train_A_C, TRAIN_A_C);
        });
    }

    private static void applyBookDest(ItemStack book, String dest) {
        RoutingTableBookContent newContent = new RoutingTableBookContent(List.of(dest), "Dev", Optional.empty());
        book.set((DataComponentType)RailcraftDataComponents.ROUTING_TABLE_BOOK.get(), (Object)newContent);
    }

    private static CreativeLocomotive spawnNewLocomotive(GameTestHelper helper, BlockPos pos, String dest) {
        CreativeLocomotive train = (CreativeLocomotive)helper.spawn((EntityType)RailcraftEntityTypes.CREATIVE_LOCOMOTIVE.get(), pos);
        train.reverse();
        train.setDestination(dest);
        train.setSpeed(Locomotive.Speed.NORMAL);
        return train;
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        return Component.literal((String)"Routing Test");
    }
}

