/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.gametest.instances;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.CreativeLocomotive;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.level.block.entity.track.RoutingTrackBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;

public class RoutingTrackTestInstance
extends GameTestInstance {
    public static final MapCodec<RoutingTrackTestInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("pullLever").forGetter(t -> t.pullLever), (App)TestData.CODEC.forGetter(t -> t.info)).apply((Applicative)instance, RoutingTrackTestInstance::new));
    private static final BlockPos SPAWN_POINT = new BlockPos(1, 1, 3);
    private static final BlockPos DEST = new BlockPos(1, 1, 6);
    private static final BlockPos LEVER_POS = new BlockPos(0, 1, 4);
    private static final BlockPos ROUTING_TRACK_POS = new BlockPos(1, 1, 4);
    private final boolean pullLever;

    public RoutingTrackTestInstance(boolean pullLever, TestData<Holder<TestEnvironmentDefinition>> info) {
        super(info);
        this.pullLever = pullLever;
    }

    public void run(GameTestHelper helper) {
        if (this.pullLever) {
            helper.pullLever(LEVER_POS);
        }
        String dest = "HOME";
        RoutingTrackBlockEntity routingTrack = (RoutingTrackBlockEntity)helper.getBlockEntity(ROUTING_TRACK_POS, RoutingTrackBlockEntity.class);
        ItemStack goldenTicket = new ItemStack((ItemLike)RailcraftItems.GOLDEN_TICKET.get());
        TicketItem.setTicketData(goldenTicket, "HOME", helper.makeMockPlayer(GameType.CREATIVE).nameAndId());
        routingTrack.setItem(0, goldenTicket);
        CreativeLocomotive train = (CreativeLocomotive)helper.spawn((EntityType)RailcraftEntityTypes.CREATIVE_LOCOMOTIVE.get(), SPAWN_POINT);
        train.setReverse(true);
        train.setSpeed(Locomotive.Speed.NORMAL);
        train.setMode(Locomotive.Mode.RUNNING);
        helper.succeedWhen(() -> {
            helper.assertEntityInstancePresent((Entity)train, DEST);
            if (this.pullLever) {
                if (train.getDestination().equals("HOME")) {
                    helper.succeed();
                } else {
                    helper.fail((Component)Component.literal((String)"Expected destination: HOME"));
                }
            } else if (train.getDestination().isEmpty()) {
                helper.succeed();
            } else {
                helper.fail((Component)Component.literal((String)"Expected empty destination"));
            }
        });
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        if (this.pullLever) {
            return Component.literal((String)"Routing Track with Lever Pulled");
        }
        return Component.literal((String)"Routing Track without Lever Pulled");
    }
}

