/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.gametest.instances.block_signal_relay_box;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.item.SignalBlockSurveyorItem;
import mods.railcraft.world.level.block.entity.signal.BlockSignalBlockEntity;
import mods.railcraft.world.level.block.entity.signal.BlockSignalRelayBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;

public class BlockSignalRelayBoxComplexTestInstance
extends GameTestInstance {
    public static final MapCodec<BlockSignalRelayBoxComplexTestInstance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("spawnCart").forGetter(t -> t.spawnCart), (App)TestData.CODEC.forGetter(t -> t.info)).apply((Applicative)instance, BlockSignalRelayBoxComplexTestInstance::new));
    private static final BlockPos BLOCK_SIGNAL_LEFT_COMPLEX = new BlockPos(7, 1, 1);
    private static final BlockPos BLOCK_SIGNAL_RIGHT_COMPLEX = new BlockPos(1, 1, 7);
    private static final BlockPos BLOCK_SIGNAL_RELAY_BOX_1_COMPLEX = new BlockPos(6, 1, 4);
    private static final BlockPos BLOCK_SIGNAL_RELAY_BOX_2_COMPLEX = new BlockPos(2, 1, 3);
    private static final BlockPos BLOCK_SIGNAL_RELAY_BOX_3_COMPLEX = new BlockPos(4, 1, 6);
    private final boolean spawnCart;

    public BlockSignalRelayBoxComplexTestInstance(boolean spawnCart, TestData<Holder<TestEnvironmentDefinition>> info) {
        super(info);
        this.spawnCart = spawnCart;
    }

    public void run(GameTestHelper helper) {
        if (this.spawnCart) {
            helper.spawn(EntityType.MINECART, new BlockPos(6, 1, 2));
        }
        helper.succeedWhen(() -> {
            SignalAspect expectedAspect;
            BlockSignalBlockEntity left = (BlockSignalBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_LEFT_COMPLEX, BlockSignalBlockEntity.class);
            BlockSignalBlockEntity right = (BlockSignalBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_RIGHT_COMPLEX, BlockSignalBlockEntity.class);
            BlockSignalRelayBoxBlockEntity box1 = (BlockSignalRelayBoxBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_RELAY_BOX_1_COMPLEX, BlockSignalRelayBoxBlockEntity.class);
            BlockSignalRelayBoxBlockEntity box2 = (BlockSignalRelayBoxBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_RELAY_BOX_2_COMPLEX, BlockSignalRelayBoxBlockEntity.class);
            BlockSignalRelayBoxBlockEntity box3 = (BlockSignalRelayBoxBlockEntity)helper.getBlockEntity(BLOCK_SIGNAL_RELAY_BOX_3_COMPLEX, BlockSignalRelayBoxBlockEntity.class);
            SignalBlockSurveyorItem.tryLinking(left, box1);
            SignalBlockSurveyorItem.tryLinking(box1, box2);
            SignalBlockSurveyorItem.tryLinking(box2, box3);
            SignalBlockSurveyorItem.tryLinking(right, box3);
            SignalAspect signalAspect = expectedAspect = this.spawnCart ? SignalAspect.RED : SignalAspect.GREEN;
            if (left.getPrimarySignalAspect().equals((Object)expectedAspect) && right.getPrimarySignalAspect().equals((Object)expectedAspect)) {
                helper.succeed();
            } else {
                String expectedText = this.spawnCart ? "Red" : "Green";
                helper.fail((Component)Component.literal((String)"Expected %s on both Signal Block".formatted(expectedText)));
            }
        });
    }

    public MapCodec<? extends GameTestInstance> codec() {
        return CODEC;
    }

    protected MutableComponent typeDescription() {
        if (this.spawnCart) {
            return Component.literal((String)"Block Signal Relay Box Complex With Cart");
        }
        return Component.literal((String)"Block Signal Relay Box Complex No Cart");
    }
}

