/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RailcraftSpecialRecipeBuilder;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.VariantSet;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.ChestMinecartDisassemblyRecipe;
import mods.railcraft.world.item.crafting.LocomotivePaintingRecipe;
import mods.railcraft.world.item.crafting.RotorRepairRecipe;
import mods.railcraft.world.item.crafting.StoneTieRecipe;
import mods.railcraft.world.item.crafting.TicketDuplicateRecipe;
import mods.railcraft.world.item.crafting.WoodenTieRecipe;
import mods.railcraft.world.item.crafting.WorldSpikeMinecartDisassemblyRecipe;
import mods.railcraft.world.level.block.DecorativeBlock;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class RailcraftRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    protected RailcraftRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.buildMultiblockBlocks();
        this.buildBlockStorageRecipes();
        this.buildIngotsRecipes();
        this.buildGears();
        this.buildKits();
        this.buildTankBlocks();
        this.buildPost();
        this.buildStrengthenedGlass();
        this.buildTie();
        this.buildCement();
        this.buildRails();
        this.buildTracks();
        this.buildSteelItems();
        this.buildTunnelBoreHead();
        this.buildMaul();
        this.buildOreSmelt();
        this.buildTurbineParts();
        this.buildChargeItems();
        this.buildSignalBox();
        this.buildSignals();
        this.buildCircuit();
        this.buildMiscItems();
        this.buildCartsVariant();
        this.buildSwitch();
        this.buildLoaders();
        this.buildCrowbars();
        this.buildFirestones();
        this.buildDecorativeStone();
        this.buildBattery();
        this.buildFrame();
        this.buildDetectors();
        this.buildWorldSpike();
    }

    private void conversion(ItemLike from, ItemLike to, int count, String optionalName) {
        ResourceLocation path = optionalName.isEmpty() ? RecipeBuilder.getDefaultRecipeId((ItemLike)to) : RailcraftConstants.rl(optionalName);
        this.shapeless(RecipeCategory.MISC, to, count).requires(from).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)from), this.has(from)).save(this.output, path.toString());
    }

    private void buildRails() {
        this.railsFromMaterials((Item)RailcraftItems.ABANDONED_TRACK.get(), 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        this.railsFromMaterials((Item)RailcraftItems.STRAP_IRON_TRACK.get(), 32, (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.railsFromMaterials(Items.RAIL, 32, (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.railsFromMaterials((Item)RailcraftItems.REINFORCED_TRACK.get(), 32, (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.railsFromMaterials((Item)RailcraftItems.ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.railsFromMaterials((Item)RailcraftItems.HIGH_SPEED_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.railsFromMaterials((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get(), 32, (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get());
        this.railsFromMaterials((Item)RailcraftItems.ELEVATOR_TRACK.get(), 8, (Item)RailcraftItems.ADVANCED_RAIL.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), Items.REDSTONE);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.WOODEN_RAIL.get(), 6).requires((ItemLike)RailcraftItems.WOODEN_TIE.get()).requires(Tags.Items.INGOTS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), this.has((ItemLike)RailcraftItems.WOODEN_TIE.get())).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.STANDARD_RAIL.get()).requires((ItemLike)Items.RAIL, 8).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.RAIL), this.has((ItemLike)Items.RAIL)).save(this.output, RailcraftConstants.rl("standard_rail_from_rail").toString());
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.WOODEN_RAILBED.get()).requires((ItemLike)RailcraftItems.WOODEN_TIE.get(), 4).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), this.has((ItemLike)RailcraftItems.WOODEN_TIE.get())).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.STONE_RAILBED.get()).requires((ItemLike)RailcraftItems.STONE_TIE.get(), 4).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())), this.has((ItemLike)RailcraftItems.WOODEN_TIE.get())).save(this.output);
    }

    private void railsFromMaterials(Item result, int count, Item railType, Item railBedType) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result, count).pattern("a a").pattern("aba").pattern("a a").define(Character.valueOf('a'), (ItemLike)railType).define(Character.valueOf('b'), (ItemLike)railBedType).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railType), this.has((ItemLike)railType)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railBedType), this.has((ItemLike)railBedType)).save(this.output);
    }

    private void railsFromMaterials(Item result, int count, Item railType, Item railBedType, Item optionalItem) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result, count).pattern("aca").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)railType).define(Character.valueOf('b'), (ItemLike)railBedType).define(Character.valueOf('c'), (ItemLike)optionalItem).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railType), this.has((ItemLike)railType)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)railBedType), this.has((ItemLike)railBedType)).save(this.output);
    }

    private void buildTracks() {
        this.tracks((Item)RailcraftItems.ABANDONED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.ABANDONED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ABANDONED_TRACK.get());
        this.tracks((Item)RailcraftItems.IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), Items.RAIL);
        this.tracks((Item)RailcraftItems.STRAP_IRON_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.STRAP_IRON_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.STRAP_IRON_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.REINFORCED_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.REINFORCED_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_BUFFER_STOP_TRACK.get(), (Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_COUPLER_TRACK.get(), (Item)RailcraftItems.COUPLER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_CONTROL_TRACK.get(), (Item)RailcraftItems.CONTROL_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_DISEMBARKING_TRACK.get(), (Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_EMBARKING_TRACK.get(), (Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_DUMPING_TRACK.get(), (Item)RailcraftItems.DUMPING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_GATED_TRACK.get(), (Item)RailcraftItems.GATED_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_LAUNCHER_TRACK.get(), (Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_ONE_WAY_TRACK.get(), (Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.ELECTRIC_ROUTING_TRACK.get(), (Item)RailcraftItems.ROUTING_TRACK_KIT.get(), (Item)RailcraftItems.ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_ACTIVATOR_TRACK.get(), (Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_BOOSTER_TRACK.get(), (Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_DETECTOR_TRACK.get(), (Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCKING_TRACK.get(), (Item)RailcraftItems.LOCKING_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_WHISTLE_TRACK.get(), (Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_LOCOMOTIVE_TRACK.get(), (Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_THROTTLE_TRACK.get(), (Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.tracks((Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRANSITION_TRACK.get(), (Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), (Item)RailcraftItems.HIGH_SPEED_ELECTRIC_TRACK.get());
        this.wyeTracks((Item)RailcraftItems.STRAP_IRON_WYE_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.wyeTracks((Item)RailcraftItems.ABANDONED_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        this.wyeTracks((Item)RailcraftItems.IRON_WYE_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.wyeTracks((Item)RailcraftItems.REINFORCED_WYE_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.wyeTracks((Item)RailcraftItems.ELECTRIC_WYE_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.wyeTracks((Item)RailcraftItems.HIGH_SPEED_WYE_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.turnoutTracks((Item)RailcraftItems.STRAP_IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.turnoutTracks((Item)RailcraftItems.ABANDONED_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        this.turnoutTracks((Item)RailcraftItems.IRON_TURNOUT_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.turnoutTracks((Item)RailcraftItems.REINFORCED_TURNOUT_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.turnoutTracks((Item)RailcraftItems.ELECTRIC_TURNOUT_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.turnoutTracks((Item)RailcraftItems.HIGH_SPEED_TURNOUT_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.junctionTracks((Item)RailcraftItems.STRAP_IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.WOODEN_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.junctionTracks((Item)RailcraftItems.ABANDONED_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_TIE.get());
        this.junctionTracks((Item)RailcraftItems.IRON_JUNCTION_TRACK.get(), (Item)RailcraftItems.STANDARD_RAIL.get(), (Item)RailcraftItems.WOODEN_RAILBED.get());
        this.junctionTracks((Item)RailcraftItems.REINFORCED_JUNCTION_TRACK.get(), (Item)RailcraftItems.REINFORCED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.junctionTracks((Item)RailcraftItems.ELECTRIC_JUNCTION_TRACK.get(), (Item)RailcraftItems.ELECTRIC_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.junctionTracks((Item)RailcraftItems.HIGH_SPEED_JUNCTION_TRACK.get(), (Item)RailcraftItems.HIGH_SPEED_RAIL.get(), (Item)RailcraftItems.STONE_RAILBED.get());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_WYE_TRACK.get(), 16).pattern("aba").pattern("aac").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), this.has((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_TURNOUT_TRACK.get(), 16).pattern("aca").pattern("aba").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), this.has((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.HIGH_SPEED_ELECTRIC_JUNCTION_TRACK.get(), 16).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.STONE_RAILBED.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())), this.has((ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get())).save(this.output);
    }

    private void tracks(Item result, Item kit, Item baseTrack) {
        this.shapeless(RecipeCategory.MISC, (ItemLike)result).requires((ItemLike)kit).requires((ItemLike)baseTrack).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)kit), this.has((ItemLike)kit)).save(this.output);
    }

    private void wyeTracks(Item result, Item rail, Item railBed) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 16).pattern("aaa").pattern("aab").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), this.has((ItemLike)rail)).save(this.output);
    }

    private void turnoutTracks(Item result, Item rail, Item railBed) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 16).pattern("aba").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), this.has((ItemLike)rail)).save(this.output);
    }

    private void junctionTracks(Item result, Item rail, Item railBed) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 16).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)rail).define(Character.valueOf('b'), (ItemLike)railBed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)rail), this.has((ItemLike)rail)).save(this.output);
    }

    private void buildSteelItems() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_ANVIL.get()).pattern("aaa").pattern(" b ").pattern("bbb").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), this.has(RailcraftTags.Items.STEEL_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_SHEARS.get()).pattern(" a").pattern("a ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_SWORD.get()).pattern("a").pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).pattern("a").pattern("b").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_PICKAXE.get()).pattern("aaa").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_AXE.get()).pattern("aa").pattern("ab").pattern(" b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_HOE.get()).pattern("aa").pattern(" b").pattern(" b").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_BOOTS.get()).pattern("a a").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_LEGGINGS.get()).pattern("aaa").pattern("a a").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_CHESTPLATE.get()).pattern("a a").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_HELMET.get()).pattern("aaa").pattern("a a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
    }

    private void buildTunnelBoreHead() {
        this.tunnelBoreHead((Item)RailcraftItems.BRONZE_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.BRONZE_BLOCK);
        this.tunnelBoreHead((Item)RailcraftItems.IRON_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_IRON);
        this.tunnelBoreHead((Item)RailcraftItems.STEEL_TUNNEL_BORE_HEAD.get(), RailcraftTags.Items.STEEL_BLOCK);
        this.tunnelBoreHead((Item)RailcraftItems.DIAMOND_TUNNEL_BORE_HEAD.get(), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_DIAMOND);
    }

    private void tunnelBoreHead(Item result, TagKey<Item> center) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), center).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).save(this.output);
    }

    private void buildMaul() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.IRON_SPIKE_MAUL.get()).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), Tags.Items.INGOTS_IRON).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_BLOCK), this.has(Tags.Items.STORAGE_BLOCKS_IRON)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEEL_SPIKE_MAUL.get()).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_BLOCK.get())), this.has(RailcraftTags.Items.STEEL_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.DIAMOND_SPIKE_MAUL.get()).pattern("aca").pattern(" b ").pattern(" b ").define(Character.valueOf('a'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('b'), Tags.Items.RODS_WOODEN).define(Character.valueOf('c'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.DIAMOND_BLOCK), this.has(Tags.Items.STORAGE_BLOCKS_DIAMOND)).save(this.output);
    }

    private void buildOreSmelt() {
        List<ItemLike> leadSmeltables = List.of((ItemLike)RailcraftItems.LEAD_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_LEAD_ORE.get(), (ItemLike)RailcraftItems.LEAD_RAW.get());
        this.oreSmelting(leadSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.LEAD_INGOT.get(), 1.0f, 200, "lead_ingot");
        this.oreBlasting(leadSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.LEAD_INGOT.get(), 1.0f, 100, "lead_ingot");
        List<ItemLike> nickelSmeltables = List.of((ItemLike)RailcraftItems.NICKEL_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_NICKEL_ORE.get(), (ItemLike)RailcraftItems.NICKEL_RAW.get());
        this.oreSmelting(nickelSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.NICKEL_INGOT.get(), 1.0f, 200, "nickel_ingot");
        this.oreBlasting(nickelSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.NICKEL_INGOT.get(), 1.0f, 100, "nickel_ingot");
        List<ItemLike> silverSmeltables = List.of((ItemLike)RailcraftItems.SILVER_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_SILVER_ORE.get(), (ItemLike)RailcraftItems.SILVER_RAW.get());
        this.oreSmelting(silverSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.SILVER_INGOT.get(), 1.0f, 200, "silver_ingot");
        this.oreBlasting(silverSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.SILVER_INGOT.get(), 1.0f, 100, "silver_ingot");
        List<ItemLike> tinSmeltables = List.of((ItemLike)RailcraftItems.TIN_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_TIN_ORE.get(), (ItemLike)RailcraftItems.TIN_RAW.get());
        this.oreSmelting(tinSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.TIN_INGOT.get(), 1.0f, 200, "tin_ingot");
        this.oreBlasting(tinSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.TIN_INGOT.get(), 1.0f, 100, "tin_ingot");
        List<ItemLike> zincSmeltables = List.of((ItemLike)RailcraftItems.ZINC_ORE.get(), (ItemLike)RailcraftItems.DEEPSLATE_ZINC_ORE.get(), (ItemLike)RailcraftItems.ZINC_RAW.get());
        this.oreSmelting(zincSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.ZINC_INGOT.get(), 1.0f, 200, "zinc_ingot");
        this.oreBlasting(zincSmeltables, RecipeCategory.MISC, (ItemLike)RailcraftItems.ZINC_INGOT.get(), 1.0f, 100, "zinc_ingot");
    }

    private void buildTurbineParts() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TURBINE_DISK.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_BLADE.get()).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TURBINE_BLADE.get())), this.has((ItemLike)RailcraftItems.TURBINE_BLADE.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TURBINE_ROTOR.get()).pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.TURBINE_DISK.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TURBINE_DISK.get())), this.has((ItemLike)RailcraftItems.TURBINE_DISK.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEAM_TURBINE.get()).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), this.has((ItemLike)RailcraftItems.CHARGE_MOTOR.get())).save(this.output);
        RailcraftSpecialRecipeBuilder.special(RotorRepairRecipe::new).save(this.output, "rotor_repair");
    }

    private void buildSignalBox() {
        this.signalBox((Item)RailcraftItems.SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.REDSTONE);
        this.signalBox((Item)RailcraftItems.SIGNAL_RECEIVER_BOX.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.REDSTONE);
        this.signalBox((Item)RailcraftItems.ANALOG_SIGNAL_CONTROLLER_BOX.get(), (Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.COMPARATOR);
        this.signalBox((Item)RailcraftItems.SIGNAL_CAPACITOR_BOX.get(), Items.REPEATER, Items.REDSTONE);
        this.signalBox((Item)RailcraftItems.SIGNAL_SEQUENCER_BOX.get(), Items.COMPARATOR, Items.REDSTONE);
        Item circuit = (Item)RailcraftItems.CONTROLLER_CIRCUIT.get();
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_INTERLOCK_BOX.get()).pattern(" d ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).define(Character.valueOf('d'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
        circuit = (Item)RailcraftItems.SIGNAL_CIRCUIT.get();
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_BLOCK_RELAY_BOX.get()).pattern(" c ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
        circuit = (Item)RailcraftItems.RADIO_CIRCUIT.get();
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TOKEN_SIGNAL_BOX.get()).pattern(" c ").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
    }

    private void signalBox(Item result, Item circuit, Item bottomItem) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)bottomItem).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
    }

    private void buildSignals() {
        this.singleSignal((Item)RailcraftItems.BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        this.singleSignal((Item)RailcraftItems.DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        this.singleSignal((Item)RailcraftItems.TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        this.dualSignal((Item)RailcraftItems.DUAL_BLOCK_SIGNAL.get(), (Item)RailcraftItems.SIGNAL_CIRCUIT.get());
        this.dualSignal((Item)RailcraftItems.DUAL_DISTANT_SIGNAL.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        this.dualSignal((Item)RailcraftItems.DUAL_TOKEN_SIGNAL.get(), (Item)RailcraftItems.RADIO_CIRCUIT.get());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).pattern("ab ").pattern("ace").pattern("adf").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), Tags.Items.DYES_LIME).define(Character.valueOf('c'), Tags.Items.DYES_YELLOW).define(Character.valueOf('d'), Tags.Items.DYES_RED).define(Character.valueOf('e'), (ItemLike)Items.GLOWSTONE_DUST).define(Character.valueOf('f'), (ItemLike)Items.REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.GLOWSTONE_DUST), this.has((ItemLike)Items.GLOWSTONE_DUST)).save(this.output);
    }

    private void singleSignal(Item result, Item circuit) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern(" dc").define(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('d'), Tags.Items.DYES_BLACK).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
    }

    private void dualSignal(Item result, Item circuit) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern(" dc").pattern("aec").define(Character.valueOf('a'), (ItemLike)RailcraftItems.SIGNAL_LAMP.get()).define(Character.valueOf('b'), (ItemLike)circuit).define(Character.valueOf('c'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('d'), Tags.Items.DYES_BLACK).define(Character.valueOf('e'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
    }

    private void buildCircuit() {
        this.circuitFromMaterial((Item)RailcraftItems.CONTROLLER_CIRCUIT.get(), Items.RED_WOOL);
        this.circuitFromMaterial((Item)RailcraftItems.RECEIVER_CIRCUIT.get(), Items.GREEN_WOOL);
        this.circuitFromMaterial((Item)RailcraftItems.SIGNAL_CIRCUIT.get(), Items.YELLOW_WOOL);
        this.circuitFromMaterial((Item)RailcraftItems.RADIO_CIRCUIT.get(), Items.BLUE_WOOL);
    }

    private void circuitFromMaterial(Item itemOut, Item woolItem) {
        this.shaped(RecipeCategory.MISC, (ItemLike)itemOut).define(Character.valueOf('W'), (ItemLike)woolItem).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('S'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('B'), Tags.Items.SLIME_BALLS).pattern(" RW").pattern("BGS").pattern("WSL").unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), this.has(Tags.Items.DUSTS_REDSTONE)).save(this.output);
    }

    private void buildSwitch() {
        this.switchItem((Item)RailcraftItems.SWITCH_TRACK_LEVER.get(), Items.LEVER);
        this.switchItem((Item)RailcraftItems.SWITCH_TRACK_MOTOR.get(), (Item)RailcraftItems.RECEIVER_CIRCUIT.get());
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.SWITCH_TRACK_ROUTER.get()).requires((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get()).requires((ItemLike)RailcraftItems.ROUTING_DETECTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get())), this.has((ItemLike)RailcraftItems.SWITCH_TRACK_MOTOR.get())).save(this.output);
    }

    private void switchItem(Item result, Item circuit) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("abc").pattern("def").define(Character.valueOf('a'), Tags.Items.DYES_RED).define(Character.valueOf('b'), Tags.Items.DYES_BLACK).define(Character.valueOf('c'), (ItemLike)Items.BONE_MEAL).define(Character.valueOf('d'), (ItemLike)Items.PISTON).define(Character.valueOf('e'), (ItemLike)circuit).define(Character.valueOf('f'), (ItemLike)Items.IRON_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)circuit), this.has((ItemLike)circuit)).save(this.output);
    }

    private void buildLoaders() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ITEM_LOADER.get()).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('b'), (ItemLike)Items.HOPPER).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_DETECTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get())), this.has((ItemLike)RailcraftItems.ITEM_DETECTOR.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ADVANCED_ITEM_LOADER.get()).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_LOADER.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_LOADER.get())), this.has((ItemLike)RailcraftItems.ITEM_LOADER.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ITEM_UNLOADER.get()).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.COBBLESTONE).define(Character.valueOf('b'), (ItemLike)RailcraftItems.ITEM_DETECTOR.get()).define(Character.valueOf('c'), (ItemLike)Items.HOPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_DETECTOR.get())), this.has((ItemLike)RailcraftItems.ITEM_DETECTOR.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ADVANCED_ITEM_UNLOADER.get()).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.ITEM_UNLOADER.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.STEEL_SHOVEL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ITEM_UNLOADER.get())), this.has((ItemLike)RailcraftItems.ITEM_UNLOADER.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FLUID_LOADER.get()).pattern("aba").pattern("a a").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.GLASS).define(Character.valueOf('b'), (ItemLike)Items.HOPPER).define(Character.valueOf('c'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), this.has((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FLUID_UNLOADER.get()).pattern("aba").pattern("a a").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.GLASS).define(Character.valueOf('b'), (ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get()).define(Character.valueOf('c'), (ItemLike)Items.HOPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())), this.has((ItemLike)RailcraftItems.DETECTOR_TRACK_KIT.get())).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.CART_DISPENSER.get()).requires((ItemLike)Items.DISPENSER).requires((ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.DISPENSER), this.has((ItemLike)Items.DISPENSER)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRAIN_DISPENSER.get()).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.REDSTONE).define(Character.valueOf('b'), RailcraftTags.Items.CROWBAR).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CART_DISPENSER.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CART_DISPENSER.get())), this.has((ItemLike)RailcraftItems.CART_DISPENSER.get())).save(this.output);
    }

    private void buildCrowbars() {
        this.crowbar((Item)RailcraftItems.IRON_CROWBAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.crowbar((Item)RailcraftItems.STEEL_CROWBAR.get(), RailcraftTags.Items.STEEL_INGOT);
        this.crowbar((Item)RailcraftItems.DIAMOND_CROWBAR.get(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND);
    }

    private void crowbar(Item itemOut, TagKey<Item> materialTag) {
        this.shaped(RecipeCategory.MISC, (ItemLike)itemOut).pattern(" ba").pattern("bab").pattern("ab ").define(Character.valueOf('a'), materialTag).define(Character.valueOf('b'), Tags.Items.DYES_RED).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.RAIL), this.has((ItemLike)Items.RAIL)).save(this.output);
    }

    private void buildFirestones() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.REFINED_FIRESTONE.get()).pattern("LRL").pattern("RSR").pattern("LRL").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('S'), (ItemLike)RailcraftItems.CUT_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CUT_FIRESTONE.get())), this.has((ItemLike)RailcraftItems.CUT_FIRESTONE.get())).save(this.output, RailcraftConstants.rl("firestone_lava_refinement").toString());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.REFINED_FIRESTONE.get()).pattern("LFL").pattern("RSR").pattern("LRL").define(Character.valueOf('L'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('S'), (ItemLike)RailcraftItems.CRACKED_FIRESTONE.get()).define(Character.valueOf('F'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get())), this.has((ItemLike)RailcraftItems.CRACKED_FIRESTONE.get())).save(this.output, RailcraftConstants.rl("firestone_cracked_fixing").toString());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CUT_FIRESTONE.get()).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), (ItemLike)Items.NETHERITE_PICKAXE).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RAW_FIRESTONE.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RAW_FIRESTONE.get())), this.has((ItemLike)RailcraftItems.RAW_FIRESTONE.get())).save(this.output);
    }

    private void buildMiscItems() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FEED_STATION.get()).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), ItemTags.PLANKS).define(Character.valueOf('b'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), this.has(RailcraftTags.Items.STEEL_PLATE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHIMNEY.get()).pattern(" a ").pattern("bcb").define(Character.valueOf('a'), (ItemLike)Items.NETHERRACK).define(Character.valueOf('b'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('c'), (ItemLike)Items.CAULDRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), this.has((ItemLike)Items.REDSTONE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.LOGBOOK.get()).pattern(" a ").pattern("bcb").pattern("ddd").define(Character.valueOf('a'), (ItemLike)Items.WRITABLE_BOOK).define(Character.valueOf('b'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('c'), (ItemLike)Items.RED_WOOL).define(Character.valueOf('d'), ItemTags.PLANKS).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WRITABLE_BOOK), this.has((ItemLike)Items.WRITABLE_BOOK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get()).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.BRONZE_GEAR).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), (ItemLike)Items.CRAFTING_TABLE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.PISTON), this.has((ItemLike)Items.PISTON)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.POWERED_ROLLING_MACHINE.get()).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_GEAR).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), (ItemLike)Items.CRAFTING_TABLE).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())), this.has((ItemLike)RailcraftItems.MANUAL_ROLLING_MACHINE.get())).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.GOLDEN_TICKET.get()).requires((ItemLike)Items.PAPER).requires(Tags.Items.NUGGETS_GOLD).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.PAPER), this.has((ItemLike)Items.PAPER)).save(this.output);
        RailcraftSpecialRecipeBuilder.special(TicketDuplicateRecipe::new).save(this.output, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.TICKET.get())));
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.ROUTING_TABLE_BOOK.get()).requires((ItemLike)Items.WRITABLE_BOOK).requires(Tags.Items.DYES_BLUE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WRITABLE_BOOK), this.has((ItemLike)Items.WRITABLE_BOOK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.OVERALLS.get()).pattern("aaa").pattern("a a").pattern("a a").define(Character.valueOf('a'), (ItemLike)Items.CYAN_WOOL).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.CYAN_WOOL), this.has((ItemLike)Items.CYAN_WOOL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.WHISTLE_TUNER.get()).pattern("a a").pattern("aaa").pattern(" a ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), this.has(RailcraftTags.Items.STEEL_NUGGET)).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_LABEL.get()).requires((ItemLike)Items.PAPER).requires(RailcraftTags.Items.STEEL_NUGGET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_NUGGET.get())), this.has((ItemLike)RailcraftItems.STEEL_NUGGET.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FORCE_TRACK_EMITTER.get()).pattern("aba").pattern("cdc").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.TIN_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.ENDER_DUST).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).define(Character.valueOf('d'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ENDER_DUST.get())), this.has((ItemLike)RailcraftItems.ENDER_DUST.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_BLOCK_SURVEYOR.get()).pattern(" a ").pattern("cbc").pattern(" d ").define(Character.valueOf('a'), (ItemLike)Items.COMPASS).define(Character.valueOf('b'), Tags.Items.GLASS_PANES).define(Character.valueOf('c'), (ItemLike)Blocks.STONE_BUTTON).define(Character.valueOf('d'), Tags.Items.DUSTS_REDSTONE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), this.has(Tags.Items.DUSTS_REDSTONE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SIGNAL_TUNER.get()).define(Character.valueOf('a'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).define(Character.valueOf('c'), (ItemLike)Blocks.STONE_BUTTON).pattern(" a ").pattern("cbc").unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.REDSTONE), this.has(Tags.Items.DUSTS_REDSTONE)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), this.has((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.GOGGLES.get()).pattern("aba").pattern("c c").pattern("ddd").define(Character.valueOf('a'), Tags.Items.GLASS_PANES).define(Character.valueOf('b'), (ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get()).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('d'), Tags.Items.LEATHERS).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has(RailcraftTags.Items.STEEL_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())), this.has((ItemLike)RailcraftItems.RECEIVER_CIRCUIT.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.WATER_TANK_SIDING.get(), 6).pattern("aaa").pattern("bcb").pattern("aaa").define(Character.valueOf('a'), ItemTags.PLANKS).define(Character.valueOf('b'), Tags.Items.INGOTS_IRON).define(Character.valueOf('c'), (ItemLike)Items.SLIME_BALL).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), this.has(Tags.Items.INGOTS_IRON)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SLIME_BALL), this.has((ItemLike)Items.SLIME_BALL)).save(this.output);
        this.shapeless(RecipeCategory.MISC, (ItemLike)Items.GUNPOWDER, 2).requires(RailcraftTags.Items.SALTPETER_DUST).requires(RailcraftTags.Items.SALTPETER_DUST).requires(RailcraftTags.Items.SULFUR_DUST).requires(RailcraftTags.Items.CHARCOAL_DUST).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), this.has(RailcraftTags.Items.SALTPETER_DUST)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SULFUR_DUST.get())), this.has(RailcraftTags.Items.SULFUR_DUST)).save(this.output);
    }

    private void buildCartsVariant() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TANK_MINECART.get()).pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftTags.Items.STRENGTHENED_GLASS).define(Character.valueOf('b'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get())), this.has((ItemLike)RailcraftItems.STRENGTHENED_GLASS.variantFor(DyeColor.WHITE).get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ENERGY_MINECART).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), RailcraftTags.Items.LEAD_INGOT).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_BLOCK).define(Character.valueOf('c'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.LEAD_INGOT.get())), this.has((ItemLike)RailcraftItems.LEAD_INGOT.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.WORLD_SPIKE_MINECART).pattern("a").pattern("b").define(Character.valueOf('a'), RailcraftItems.WORLD_SPIKE).define(Character.valueOf('b'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName(RailcraftItems.WORLD_SPIKE), this.has((ItemLike)RailcraftItems.WORLD_SPIKE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TUNNEL_BORE.get()).pattern("aba").pattern("cbc").pattern(" d ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.MINECART).define(Character.valueOf('c'), (ItemLike)Items.FURNACE).define(Character.valueOf('d'), (ItemLike)Items.CHEST_MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get()).pattern("aab").pattern("aab").pattern("cdd").define(Character.valueOf('a'), RailcraftTags.Items.IRON_TANK_WALL).define(Character.valueOf('b'), (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()).define(Character.valueOf('c'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('d'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ELECTRIC_LOCOMOTIVE.get()).pattern("ab ").pattern("cdc").pattern("efe").define(Character.valueOf('a'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('b'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).define(Character.valueOf('d'), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.NICKEL_IRON_BATTERY.get(), (ItemLike)RailcraftItems.NICKEL_ZINC_BATTERY.get()})).define(Character.valueOf('e'), RailcraftTags.Items.STEEL_GEAR).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        RailcraftSpecialRecipeBuilder.special(LocomotivePaintingRecipe::new).save(this.output, "locomotive_color_variant");
        RailcraftSpecialRecipeBuilder.special(ChestMinecartDisassemblyRecipe::new).save(this.output, "chest_minecart_disassembly");
        RailcraftSpecialRecipeBuilder.special(WorldSpikeMinecartDisassemblyRecipe::new).save(this.output, "worldspike_minecart_disassembly");
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRACK_LAYER.get()).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.ANVIL).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DISPENSER).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRACK_RELAYER.get()).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DIAMOND_PICKAXE).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRACK_REMOVER.get()).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.STICKY_PISTON).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), RailcraftTags.Items.CROWBAR).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRACK_UNDERCUTTER.get()).pattern("aba").pattern("cdc").pattern("efe").define(Character.valueOf('a'), Tags.Items.DYES_YELLOW).define(Character.valueOf('b'), (ItemLike)Items.REDSTONE_LAMP).define(Character.valueOf('c'), (ItemLike)Items.PISTON).define(Character.valueOf('d'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('e'), (ItemLike)Items.DIAMOND_SHOVEL).define(Character.valueOf('f'), (ItemLike)Items.MINECART).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MINECART), this.has((ItemLike)Items.MINECART)).save(this.output);
    }

    private void buildChargeItems() {
        this.conversion((ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get(), 3, "charge_spool_small_from_medium");
        this.conversion((ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get(), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get(), 3, "charge_spool_medium_from_large");
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).pattern(" b ").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.BRASS_INGOT).define(Character.valueOf('b'), RailcraftTags.Items.BRASS_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), this.has(RailcraftTags.Items.BRASS_INGOT)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHARGE_COIL.get()).pattern("aaa").pattern("bbb").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).define(Character.valueOf('b'), RailcraftTags.Items.IRON_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), this.has((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).pattern(" a ").pattern("bcb").pattern(" d ").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), RailcraftTags.Items.TIN_PLATE).define(Character.valueOf('c'), (ItemLike)RailcraftItems.CHARGE_COIL.get()).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())), this.has((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHARGE_METER.get()).pattern("a a").pattern("bcb").pattern(" d ").define(Character.valueOf('a'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('b'), (ItemLike)Items.STONE_BUTTON).define(Character.valueOf('c'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('d'), RailcraftTags.Items.BRASS_INGOT).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BRASS_INGOT.get())), this.has((ItemLike)RailcraftItems.BRASS_INGOT.get())).save(this.output);
    }

    private void buildKits() {
        this.kits((Item)RailcraftItems.ACTIVATOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)2)));
        this.kits((Item)RailcraftItems.BOOSTER_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.ADVANCED_RAIL.get())), (Object)2), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.BUFFER_STOP_TRACK_KIT.get(), 2, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), (Object)2)));
        this.kits((Item)RailcraftItems.CONTROL_TRACK_KIT.get(), 16, List.of(new Tuple((Object)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.ADVANCED_RAIL.get())), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.DETECTOR_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.STONE_PRESSURE_PLATE), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.DISEMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.STONE_PRESSURE_PLATE), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)Items.LEAD), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.EMBARKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.ENDER_PEARL), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)Items.LEAD), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.DUMPING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_PLATE)), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.GATED_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.FENCE_GATES)), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.ADVANCED_RAIL.get())), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.LOCKING_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.STONE_PRESSURE_PLATE), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)Items.STICKY_PISTON), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.ONE_WAY_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.STONE_PRESSURE_PLATE), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)Items.PISTON), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.LAUNCHER_TRACK_KIT.get(), 1, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.PISTON), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_BLOCK)), (Object)2), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.LOCOMOTIVE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.SIGNAL_LAMP.get())), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.TRANSITION_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.ADVANCED_RAIL.get())), (Object)2), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)2)));
        this.kits((Item)RailcraftItems.COUPLER_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((ItemLike)Items.LEAD), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.ROUTING_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.TICKET.get(), (ItemLike)RailcraftItems.GOLDEN_TICKET.get()}), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.THROTTLE_TRACK_KIT.get(), 4, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DYES_YELLOW)), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DYES_BLACK)), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
        this.kits((Item)RailcraftItems.WHISTLE_TRACK_KIT.get(), 8, List.of(new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DYES_YELLOW)), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DYES_BLACK)), (Object)1), new Tuple((Object)Ingredient.of((ItemLike)Items.NOTE_BLOCK), (Object)1), new Tuple((Object)Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), (Object)1)));
    }

    private void kits(Item result, int count, List<Tuple<Ingredient, Integer>> ingredients) {
        ShapelessRecipeBuilder builder = this.shapeless(RecipeCategory.MISC, (ItemLike)result, count).requires(ItemTags.PLANKS).requires((ItemLike)RailcraftItems.TRACK_PARTS.get());
        for (Tuple<Ingredient, Integer> ingredient : ingredients) {
            builder = builder.requires((Ingredient)ingredient.getA(), ((Integer)ingredient.getB()).intValue());
        }
        builder.unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TRACK_PARTS.get())), this.has((ItemLike)RailcraftItems.TRACK_PARTS.get())).save(this.output);
    }

    private void buildGears() {
        this.square2x2(RailcraftTags.Items.BRONZE_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_bronze");
        this.square2x2(RailcraftTags.Items.BRASS_INGOT, (Item)RailcraftItems.BUSHING_GEAR.get(), 1, "_brass");
        this.gear((Item)RailcraftItems.IRON_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_IRON);
        this.gear((Item)RailcraftItems.COPPER_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_COPPER);
        this.gear((Item)RailcraftItems.GOLD_GEAR.get(), (TagKey<Item>)Tags.Items.INGOTS_GOLD);
        this.gear((Item)RailcraftItems.STEEL_GEAR.get(), RailcraftTags.Items.STEEL_INGOT);
        this.gear((Item)RailcraftItems.TIN_GEAR.get(), RailcraftTags.Items.TIN_INGOT);
        this.gear((Item)RailcraftItems.ZINC_GEAR.get(), RailcraftTags.Items.ZINC_INGOT);
        this.gear((Item)RailcraftItems.BRASS_GEAR.get(), RailcraftTags.Items.BRASS_INGOT);
        this.gear((Item)RailcraftItems.BRONZE_GEAR.get(), RailcraftTags.Items.BRONZE_INGOT);
        this.gear((Item)RailcraftItems.NICKEL_GEAR.get(), RailcraftTags.Items.NICKEL_INGOT);
        this.gear((Item)RailcraftItems.INVAR_GEAR.get(), RailcraftTags.Items.INVAR_INGOT);
        this.gear((Item)RailcraftItems.SILVER_GEAR.get(), RailcraftTags.Items.SILVER_INGOT);
        this.gear((Item)RailcraftItems.LEAD_GEAR.get(), RailcraftTags.Items.LEAD_INGOT);
    }

    private void gear(Item itemOut, TagKey<Item> materialTag) {
        this.shaped(RecipeCategory.MISC, (ItemLike)itemOut).pattern(" a ").pattern("aba").pattern(" a ").define(Character.valueOf('a'), materialTag).define(Character.valueOf('b'), (ItemLike)RailcraftItems.BUSHING_GEAR.get()).unlockedBy("has_material", this.has(materialTag)).save(this.output);
    }

    private void buildMultiblockBlocks() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FLUID_FUELED_FIREBOX.get()).pattern("aca").pattern("bdb").pattern("aea").define(Character.valueOf('a'), RailcraftTags.Items.INVAR_PLATE).define(Character.valueOf('b'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('c'), (ItemLike)Items.BUCKET).define(Character.valueOf('d'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('e'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.INVAR_PLATE.get())), this.has((ItemLike)RailcraftItems.INVAR_PLATE.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SOLID_FUELED_FIREBOX.get()).pattern("aaa").pattern("aba").pattern("aca").define(Character.valueOf('a'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('b'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('c'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.FIRE_CHARGE), this.has((ItemLike)Items.FIRE_CHARGE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.COKE_OVEN_BRICKS.get(), 2).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.SAND).define(Character.valueOf('b'), (ItemLike)Items.BRICK).define(Character.valueOf('c'), (ItemLike)Items.CLAY).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.BRICK), this.has((ItemLike)Items.BRICK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get(), 4).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.SOUL_SAND).define(Character.valueOf('b'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('c'), (ItemLike)Items.MAGMA_CREAM).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MAGMA_CREAM), this.has((ItemLike)Items.MAGMA_CREAM)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CRUSHER.get(), 4).pattern("aba").pattern("bcb").pattern("ada").define(Character.valueOf('a'), (ItemLike)Items.DIAMOND).define(Character.valueOf('b'), (ItemLike)Items.PISTON).define(Character.valueOf('c'), RailcraftTags.Items.STEEL_BLOCK).define(Character.valueOf('d'), (ItemLike)RailcraftItems.CHARGE_MOTOR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.CHARGE_MOTOR.get())), this.has((ItemLike)RailcraftItems.CHARGE_MOTOR.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.HIGH_PRESSURE_STEAM_BOILER_TANK.get(), 2).pattern("a").pattern("b").pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), this.has((ItemLike)RailcraftItems.STEEL_PLATE.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.LOW_PRESSURE_STEAM_BOILER_TANK.get(), 2).pattern("a").pattern("b").pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.IRON_PLATE).define(Character.valueOf('b'), RailcraftTags.Items.INVAR_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.IRON_PLATE.get())), this.has((ItemLike)RailcraftItems.IRON_PLATE.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.STEAM_OVEN.get(), 4).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_PLATE).define(Character.valueOf('b'), (ItemLike)Items.FURNACE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_PLATE.get())), this.has((ItemLike)RailcraftItems.STEEL_PLATE.get())).save(this.output);
    }

    private void buildBlockStorageRecipes() {
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.STEEL_NUGGET.get(), (ItemLike)RailcraftItems.STEEL_INGOT.get(), "steel_ingot_from_steel_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.TIN_NUGGET.get(), (ItemLike)RailcraftItems.TIN_INGOT.get(), "tin_ingot_from_tin_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.ZINC_NUGGET.get(), (ItemLike)RailcraftItems.ZINC_INGOT.get(), "zinc_ingot_from_zinc_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.BRASS_NUGGET.get(), (ItemLike)RailcraftItems.BRASS_INGOT.get(), "brass_ingot_from_brass_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.BRONZE_NUGGET.get(), (ItemLike)RailcraftItems.BRONZE_INGOT.get(), "bronze_ingot_from_bronze_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.NICKEL_NUGGET.get(), (ItemLike)RailcraftItems.NICKEL_INGOT.get(), "nickel_ingot_from_nickel_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.INVAR_NUGGET.get(), (ItemLike)RailcraftItems.INVAR_INGOT.get(), "invar_ingot_from_invar_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.SILVER_NUGGET.get(), (ItemLike)RailcraftItems.SILVER_INGOT.get(), "silver_ingot_from_silver_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.LEAD_NUGGET.get(), (ItemLike)RailcraftItems.LEAD_INGOT.get(), "lead_ingot_from_lead_nugget");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.STEEL_INGOT.get(), (ItemLike)RailcraftItems.STEEL_BLOCK.get(), "steel_block_from_steel_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.TIN_INGOT.get(), (ItemLike)RailcraftItems.TIN_BLOCK.get(), "tin_block_from_tin_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.ZINC_INGOT.get(), (ItemLike)RailcraftItems.ZINC_BLOCK.get(), "zinc_block_from_zinc_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.BRASS_INGOT.get(), (ItemLike)RailcraftItems.BRASS_BLOCK.get(), "brass_block_from_brass_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.BRONZE_INGOT.get(), (ItemLike)RailcraftItems.BRONZE_BLOCK.get(), "bronze_block_from_bronze_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.NICKEL_INGOT.get(), (ItemLike)RailcraftItems.NICKEL_BLOCK.get(), "nickel_block_from_nickel_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.INVAR_INGOT.get(), (ItemLike)RailcraftItems.INVAR_BLOCK.get(), "invar_block_from_invar_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.SILVER_INGOT.get(), (ItemLike)RailcraftItems.SILVER_BLOCK.get(), "silver_block_from_silver_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.LEAD_INGOT.get(), (ItemLike)RailcraftItems.LEAD_BLOCK.get(), "lead_block_from_lead_ingot");
        this.nineBlockStorageRecipes((ItemLike)RailcraftItems.COAL_COKE.get(), (ItemLike)RailcraftItems.COAL_COKE_BLOCK.get(), "coal_coke_block_from_coal_coke");
    }

    private void nineBlockStorageRecipes(ItemLike unpacked, ItemLike packed, String packingRecipeName) {
        this.shapeless(RecipeCategory.MISC, unpacked, 9).requires(packed).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)packed), this.has(packed)).save(this.output);
        this.shaped(RecipeCategory.MISC, packed).pattern("aaa").pattern("aaa").pattern("aaa").define(Character.valueOf('a'), unpacked).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)unpacked), this.has(unpacked)).save(this.output, RailcraftConstants.rl(packingRecipeName).toString());
    }

    private void buildIngotsRecipes() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.BRONZE_INGOT.get(), 4).pattern("ab").pattern("bb").define(Character.valueOf('a'), RailcraftTags.Items.TIN_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.TIN_INGOT.get())), this.has(RailcraftTags.Items.TIN_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.COPPER_INGOT), this.has(Tags.Items.INGOTS_COPPER)).save(this.output, RailcraftConstants.rl("bronze_ingot_crafted_with_ingots").toString());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.BRASS_INGOT.get(), 4).pattern("ab").pattern("bb").define(Character.valueOf('a'), RailcraftTags.Items.ZINC_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_COPPER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.ZINC_INGOT.get())), this.has(RailcraftTags.Items.ZINC_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.COPPER_INGOT), this.has(Tags.Items.INGOTS_COPPER)).save(this.output, RailcraftConstants.rl("brass_ingot_crafted_with_ingots").toString());
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.INVAR_INGOT.get(), 3).pattern("ab").pattern("b ").define(Character.valueOf('a'), RailcraftTags.Items.NICKEL_INGOT).define(Character.valueOf('b'), Tags.Items.INGOTS_IRON).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.NICKEL_INGOT.get())), this.has(RailcraftTags.Items.NICKEL_INGOT)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.IRON_INGOT), this.has(Tags.Items.INGOTS_IRON)).save(this.output, RailcraftConstants.rl("invar_ingot_crafted_with_ingots").toString());
    }

    private void buildStrengthenedGlass() {
        Map<String, TagKey> ingredients = Map.of("tin", RailcraftTags.Items.TIN_INGOT, "nickel", RailcraftTags.Items.NICKEL_INGOT, "invar", RailcraftTags.Items.INVAR_INGOT, "brass", RailcraftTags.Items.BRASS_INGOT, "iron", Tags.Items.INGOTS_IRON);
        VariantSet<DyeColor, Item, BlockItem> colorItems = RailcraftItems.STRENGTHENED_GLASS;
        TagKey<Item> tagItem = RailcraftTags.Items.STRENGTHENED_GLASS;
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        for (Map.Entry<String, TagKey> ingredient : ingredients.entrySet()) {
            String recipeName = name.substring(name.indexOf(95) + 1) + "_" + ingredient.getKey();
            this.shaped(RecipeCategory.MISC, (ItemLike)result, 6).pattern("aba").pattern("aca").pattern("ada").define(Character.valueOf('a'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('b'), ingredient.getValue()).define(Character.valueOf('c'), (ItemLike)RailcraftItems.SALTPETER_DUST.get()).define(Character.valueOf('d'), (ItemLike)Items.WATER_BUCKET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SALTPETER_DUST.get())), this.has((ItemLike)RailcraftItems.SALTPETER_DUST.get())).save(this.output, RailcraftConstants.rl(recipeName).toString());
        }
        this.coloredBlockVariant(colorItems, tagItem);
    }

    private void buildTie() {
        RailcraftSpecialRecipeBuilder.special(WoodenTieRecipe::new).save(this.output, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.WOODEN_TIE.get())));
        RailcraftSpecialRecipeBuilder.special(StoneTieRecipe::new).save(this.output, RailcraftRecipeProvider.getItemName((ItemLike)((ItemLike)RailcraftItems.STONE_TIE.get())));
    }

    private void buildCement() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.BAG_OF_CEMENT.get(), 2).pattern("ab").pattern("ba").define(Character.valueOf('a'), (ItemLike)Items.GRAVEL).define(Character.valueOf('b'), (ItemLike)Items.QUARTZ).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.QUARTZ), this.has((ItemLike)Items.QUARTZ)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.BAG_OF_CEMENT.get(), 2).pattern("ab").pattern("ca").define(Character.valueOf('a'), (ItemLike)Items.GRAVEL).define(Character.valueOf('b'), (ItemLike)Items.QUARTZ).define(Character.valueOf('c'), (ItemLike)RailcraftItems.SLAG.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.SLAG.get())), this.has((ItemLike)RailcraftItems.SLAG.get())).save(this.output, RailcraftConstants.rl("bag_of_cement_slag").toString());
    }

    private void tankWall(TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 8).pattern("aa").pattern("aa").define(Character.valueOf('a'), ingredientTag).unlockedBy(ingredient, this.has(ingredientTag)).save(this.output, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)).toString());
        this.coloredBlockVariant(colorItems, tagItem);
    }

    private void tankValve(TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 8).pattern("aba").pattern("bcb").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.IRON_BARS).define(Character.valueOf('b'), ingredientTag).define(Character.valueOf('c'), (ItemLike)Items.LEVER).unlockedBy(ingredient, this.has(ingredientTag)).save(this.output, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)).toString());
        this.coloredBlockVariant(colorItems, tagItem);
    }

    private void tankGauge(TagKey<Item> ingredientTag, VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        BlockItem result = (BlockItem)colorItems.variantFor(DyeColor.WHITE).get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        String ingredient = ingredientTag.equals(RailcraftTags.Items.IRON_PLATE) ? "has_iron_plate" : "has_steel_plate";
        this.shaped(RecipeCategory.MISC, (ItemLike)result, 8).pattern("aba").pattern("bab").pattern("aba").define(Character.valueOf('a'), (ItemLike)Items.GLASS_PANE).define(Character.valueOf('b'), ingredientTag).unlockedBy(ingredient, this.has(ingredientTag)).save(this.output, RailcraftConstants.rl(name.substring(name.indexOf(95) + 1)).toString());
        this.coloredBlockVariant(colorItems, tagItem);
    }

    private void buildTankBlocks() {
        this.tankWall(RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_WALL, RailcraftTags.Items.IRON_TANK_WALL);
        this.tankWall(RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_WALL, RailcraftTags.Items.STEEL_TANK_WALL);
        this.tankValve(RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_VALVE, RailcraftTags.Items.IRON_TANK_VALVE);
        this.tankValve(RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_VALVE, RailcraftTags.Items.STEEL_TANK_VALVE);
        this.tankGauge(RailcraftTags.Items.IRON_PLATE, RailcraftItems.IRON_TANK_GAUGE, RailcraftTags.Items.IRON_TANK_GAUGE);
        this.tankGauge(RailcraftTags.Items.STEEL_PLATE, RailcraftItems.STEEL_TANK_GAUGE, RailcraftTags.Items.STEEL_TANK_GAUGE);
    }

    private void buildPost() {
        this.coloredBlockVariant(RailcraftItems.POST, RailcraftTags.Items.POST, DyeColor.BLACK);
    }

    private void buildDecorativeStone() {
        for (DecorativeBlock type : DecorativeBlock.values()) {
            this.square2x2((Item)RailcraftItems.DECORATIVE_STONE.variantFor(type).get(), (Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), 4, "_from_%s_stone".formatted(type.getSerializedName()));
            this.square2x2((Item)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get(), (Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), 4, "_from_%s_cobblestone".formatted(type.getSerializedName()));
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get())), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get())), this.has((ItemLike)RailcraftItems.DECORATIVE_STONE.variantFor(type).get())).save(this.output, RailcraftConstants.rl("polished_%s_stone_from_%s_stone_in_stonecutter".formatted(type.getSerializedName(), type.getSerializedName())).toString());
            SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get())), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get())), this.has((ItemLike)RailcraftItems.DECORATIVE_COBBLESTONE.variantFor(type).get())).save(this.output, RailcraftConstants.rl("polished_%s_stone_from_%s_cobblestone_in_stonecutter".formatted(type.getSerializedName(), type.getSerializedName())).toString());
            this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.CHISELED_DECORATIVE_STONE.variantFor(type).get(), 8).pattern("aaa").pattern("a a").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())), this.has((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).save(this.output);
            this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ETCHED_DECORATIVE_STONE.variantFor(type).get(), 8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get()).define(Character.valueOf('b'), (ItemLike)Items.GUNPOWDER).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())), this.has((ItemLike)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get())).save(this.output);
            this.square2x2((Item)RailcraftItems.POLISHED_DECORATIVE_STONE.variantFor(type).get(), (Item)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get(), 4, "");
            this.stairBuilder((ItemLike)RailcraftItems.DECORATIVE_BRICK_STAIRS.variantFor(type).get(), Ingredient.of((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get()))).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get())), this.has((ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get())).save(this.output);
            this.slab(RecipeCategory.MISC, (ItemLike)RailcraftItems.DECORATIVE_BRICK_SLAB.variantFor(type).get(), (ItemLike)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get());
            this.square2x2((Item)RailcraftItems.DECORATIVE_BRICKS.variantFor(type).get(), (Item)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get(), 4, "");
            this.stairBuilder((ItemLike)RailcraftItems.DECORATIVE_PAVER_STAIRS.variantFor(type).get(), Ingredient.of((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get()))).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get())), this.has((ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get())).save(this.output);
            this.slab(RecipeCategory.MISC, (ItemLike)RailcraftItems.DECORATIVE_PAVER_SLAB.variantFor(type).get(), (ItemLike)RailcraftItems.DECORATIVE_PAVER.variantFor(type).get());
        }
    }

    private void buildBattery() {
        this.battery((Item)RailcraftItems.NICKEL_ZINC_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get());
        this.battery((Item)RailcraftItems.NICKEL_IRON_BATTERY.get(), (Item)RailcraftItems.NICKEL_ELECTRODE.get(), (Item)RailcraftItems.IRON_ELECTRODE.get());
        this.battery((Item)RailcraftItems.ZINC_SILVER_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.SILVER_ELECTRODE.get());
        this.battery((Item)RailcraftItems.ZINC_CARBON_BATTERY.get(), (Item)RailcraftItems.ZINC_ELECTRODE.get(), (Item)RailcraftItems.CARBON_ELECTRODE.get());
    }

    private void battery(Item result, Item left, Item right) {
        this.shaped(RecipeCategory.MISC, (ItemLike)result).pattern("aba").pattern("cde").pattern("cfe").define(Character.valueOf('a'), (ItemLike)RailcraftItems.CHARGE_TERMINAL.get()).define(Character.valueOf('b'), (ItemLike)RailcraftItems.CHARGE_SPOOL_MEDIUM.get()).define(Character.valueOf('c'), (ItemLike)left).define(Character.valueOf('d'), RailcraftTags.Items.SALTPETER_DUST).define(Character.valueOf('e'), (ItemLike)right).define(Character.valueOf('f'), (ItemLike)Items.WATER_BUCKET).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)left), this.has((ItemLike)left)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)right), this.has((ItemLike)right)).save(this.output);
    }

    private void buildFrame() {
        this.frame(6, RailcraftTags.Items.IRON_PLATE, "_iron_plate");
        this.frame(6, RailcraftTags.Items.BRONZE_PLATE, "_bronze_plate");
        this.frame(6, RailcraftTags.Items.BRASS_PLATE, "_brass_plate");
        this.frame(10, RailcraftTags.Items.STEEL_PLATE, "_steel_plate");
    }

    private void frame(int count, TagKey<Item> tag, String suffix) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)((ItemLike)RailcraftItems.FRAME_BLOCK.get())).getPath();
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.FRAME_BLOCK.get(), count).pattern("aaa").pattern("b b").pattern("bbb").define(Character.valueOf('a'), tag).define(Character.valueOf('b'), (ItemLike)RailcraftItems.REBAR.get()).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.REBAR.get())), this.has((ItemLike)RailcraftItems.REBAR.get())).save(this.output, RailcraftConstants.rl(name + suffix).toString());
    }

    private void buildDetectors() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ADVANCED_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_INGOT).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.STEEL_INGOT.get())), this.has((ItemLike)RailcraftItems.STEEL_INGOT.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.AGE_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.DARK_OAK_LOG).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SPRUCE_LOG), this.has((ItemLike)Items.SPRUCE_LOG)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ANIMAL_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.OAK_LOG).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.SPRUCE_LOG), this.has((ItemLike)Items.SPRUCE_LOG)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ANY_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE), this.has((ItemLike)Items.STONE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.EMPTY_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE_BRICKS).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE_BRICKS), this.has((ItemLike)Items.STONE_BRICKS)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ITEM_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STRIPPED_ACACIA_WOOD).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STRIPPED_ACACIA_WOOD), this.has((ItemLike)Items.STRIPPED_ACACIA_WOOD)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.LOCOMOTIVE_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get()).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get())), this.has((ItemLike)RailcraftItems.BLAST_FURNACE_BRICKS.get())).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.MOB_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.MOSSY_COBBLESTONE).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.MOSSY_COBBLESTONE), this.has((ItemLike)Items.MOSSY_COBBLESTONE)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.PLAYER_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.STONE_SLAB).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.STONE_SLAB), this.has((ItemLike)Items.STONE_SLAB)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.ROUTING_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.CHISELED_QUARTZ_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.CHISELED_QUARTZ_BLOCK), this.has((ItemLike)Items.CHISELED_QUARTZ_BLOCK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.SHEEP_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), ItemTags.WOOL).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.WHITE_WOOL), this.has((ItemLike)Items.WHITE_WOOL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TANK_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.BRICK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.BRICK), this.has((ItemLike)Items.BRICK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.TRAIN_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.NETHER_BRICK).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.NETHER_BRICK), this.has((ItemLike)Items.NETHER_BRICK)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.VILLAGER_DETECTOR.get()).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), (ItemLike)Items.LEATHER).define(Character.valueOf('b'), (ItemLike)Items.STONE_PRESSURE_PLATE).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.LEATHER), this.has((ItemLike)Items.LEATHER)).save(this.output);
    }

    private void buildWorldSpike() {
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.WORLD_SPIKE.get()).pattern("gog").pattern("dpd").pattern("gog").define(Character.valueOf('d'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('p'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('o'), (ItemLike)Items.OBSIDIAN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), this.has((ItemLike)Items.ENDER_PEARL)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)RailcraftItems.PERSONAL_WORLD_SPIKE.get()).pattern("gog").pattern("dpd").pattern("gog").define(Character.valueOf('d'), Tags.Items.GEMS_EMERALD).define(Character.valueOf('g'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('p'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('o'), (ItemLike)Items.OBSIDIAN).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)Items.ENDER_PEARL), this.has((ItemLike)Items.ENDER_PEARL)).save(this.output);
    }

    private void square2x2(TagKey<Item> ingredient, Item result, int quantity, String suffix) {
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
        this.shaped(RecipeCategory.MISC, (ItemLike)result, quantity).pattern("aa").pattern("aa").define(Character.valueOf('a'), ingredient).unlockedBy("has_material", this.has(ingredient)).save(this.output, RailcraftConstants.rl(name + suffix).toString());
    }

    private void square2x2(Item ingredient, Item result, int quantity, String suffix) {
        ShapedRecipeBuilder builder = this.shaped(RecipeCategory.MISC, (ItemLike)result, quantity).pattern("aa").pattern("aa").define(Character.valueOf('a'), (ItemLike)ingredient).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)ingredient), this.has((ItemLike)ingredient));
        if (suffix.isEmpty()) {
            builder.save(this.output);
        } else {
            String name = RecipeBuilder.getDefaultRecipeId((ItemLike)result).getPath();
            builder.save(this.output, RailcraftConstants.rl(name + suffix).toString());
        }
    }

    private void coloredBlockVariant(VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem) {
        this.coloredBlockVariant(colorItems, tagItem, DyeColor.WHITE);
    }

    private void coloredBlockVariant(VariantSet<DyeColor, Item, BlockItem> colorItems, TagKey<Item> tagItem, DyeColor baseColor) {
        BlockItem base = (BlockItem)colorItems.variantFor(baseColor).get();
        for (DyeColor dyeColor : DyeColor.values()) {
            this.shaped(RecipeCategory.MISC, (ItemLike)colorItems.variantFor(dyeColor).get(), 8).pattern("aaa").pattern("aba").pattern("aaa").define(Character.valueOf('a'), tagItem).define(Character.valueOf('b'), (ItemLike)DyeItem.byColor((DyeColor)dyeColor)).unlockedBy(RailcraftRecipeProvider.getHasName((ItemLike)base), this.has((ItemLike)base)).save(this.output);
        }
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new RailcraftRecipeProvider(registries, output);
        }

        public String getName() {
            return "RailcraftRecipeProvider";
        }
    }
}

