/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import mods.railcraft.world.item.crafting.RollingRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.ItemLike;

public class RollingRecipeBuilder {
    public static final int DEFAULT_PROCESSING_TIME = 100;
    private final Item result;
    private final int count;
    private final int processTime;
    private final List<String> rows = Lists.newArrayList();
    private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();

    private RollingRecipeBuilder(ItemLike result, int count, int processTime) {
        this.result = result.asItem();
        this.count = count;
        this.processTime = processTime;
    }

    public static RollingRecipeBuilder rolled(ItemLike result) {
        return RollingRecipeBuilder.rolled(result, 1);
    }

    public static RollingRecipeBuilder rolled(ItemLike result, int count) {
        return RollingRecipeBuilder.rolled(result, count, 100);
    }

    public static RollingRecipeBuilder rolled(ItemLike result, int count, int processTime) {
        return new RollingRecipeBuilder(result, count, processTime);
    }

    public RollingRecipeBuilder define(HolderLookup.RegistryLookup<Item> items, Character key, TagKey<Item> itemTagValue) {
        return this.define(key, Ingredient.of((HolderSet)items.getOrThrow(itemTagValue)));
    }

    public RollingRecipeBuilder define(Character key, ItemLike itemValue) {
        return this.define(key, Ingredient.of((ItemLike)itemValue));
    }

    public RollingRecipeBuilder define(Character key, Ingredient itemValue) {
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Symbol '" + key + "' is already defined!");
        }
        if (key.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.key.put(key, itemValue);
        return this;
    }

    public RollingRecipeBuilder pattern(String pattern) {
        if (!this.rows.isEmpty() && pattern.length() != this.rows.getFirst().length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.rows.add(pattern);
        return this;
    }

    public void save(RecipeOutput recipeOutput) {
        this.save(recipeOutput, BuiltInRegistries.ITEM.getKey((Object)this.result));
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        ResourceLocation customResourceLocation = resourceLocation.withPrefix("rolling/");
        ShapedRecipePattern pattern = ShapedRecipePattern.of(this.key, this.rows);
        RollingRecipe recipe = new RollingRecipe(pattern, new ItemStack((ItemLike)this.result, this.count), this.processTime);
        recipeOutput.accept(ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)customResourceLocation), (Recipe)recipe, null);
    }
}

