/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.concurrent.CompletableFuture;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RollingRecipeBuilder;
import mods.railcraft.data.recipes.patterns.RollingRecipePattern;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class RollingRecipeProvider
extends RecipeProvider {
    private final HolderLookup.RegistryLookup<Item> items;

    private RollingRecipeProvider(HolderLookup.Provider registries, RecipeOutput recipeOutput) {
        super(registries, recipeOutput);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.misc();
        this.buildChargeSpool();
        this.buildTrackParts();
        this.buildRebars();
        this.buildElectrodes();
        this.buildRails();
        this.buildPlates();
    }

    private void misc() {
        RollingRecipePattern.hForm(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), (ItemLike)RailcraftItems.POST.variantFor(DyeColor.BLACK).get(), 16);
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_PLATE)), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "steel_turbine_blade");
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.NICKEL_PLATE)), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "nickel_turbine_blade");
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRONZE_PLATE)), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_bronze");
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRASS_PLATE)), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_brass");
    }

    private void buildChargeSpool() {
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get()).pattern("a").define(this.items, Character.valueOf('a'), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).save(this.output);
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).pattern("a").define(this.items, Character.valueOf('a'), (TagKey<Item>)Tags.Items.INGOTS_COPPER).save(this.output);
    }

    private void buildTrackParts() {
        Item trackParts = (Item)RailcraftItems.TRACK_PARTS.get();
        String name = RecipeBuilder.getDefaultRecipeId((ItemLike)trackParts).getPath();
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa ").pattern("a  ").define(this.items, Character.valueOf('a'), RailcraftTags.Items.BRONZE_NUGGET).save(this.output, RailcraftConstants.rl(name + "_bronze_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa").define(this.items, Character.valueOf('a'), (TagKey<Item>)Tags.Items.NUGGETS_IRON).save(this.output, RailcraftConstants.rl(name + "_iron_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("a").define(this.items, Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).save(this.output, RailcraftConstants.rl(name + "_steel_nugget"));
    }

    private void buildRebars() {
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_iron");
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRONZE_INGOT)), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_bronze");
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_INGOT)), (ItemLike)RailcraftItems.REBAR.get(), 6, "rebar_invar");
        RollingRecipePattern.diagonalLine(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), (ItemLike)RailcraftItems.REBAR.get(), 8, "rebar_steel");
    }

    private void buildElectrodes() {
        RollingRecipePattern.line(this.output, Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL}), (ItemLike)RailcraftItems.CARBON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.NICKEL_PLATE)), (ItemLike)RailcraftItems.NICKEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.IRON_PLATE)), (ItemLike)RailcraftItems.IRON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.ZINC_PLATE)), (ItemLike)RailcraftItems.ZINC_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.SILVER_PLATE)), (ItemLike)RailcraftItems.SILVER_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_PLATE)), (ItemLike)RailcraftItems.STEEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.TIN_PLATE)), (ItemLike)RailcraftItems.TIN_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.GOLD_PLATE)), (ItemLike)RailcraftItems.GOLD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.LEAD_PLATE)), (ItemLike)RailcraftItems.LEAD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRASS_PLATE)), (ItemLike)RailcraftItems.BRASS_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_PLATE)), (ItemLike)RailcraftItems.INVAR_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRONZE_PLATE)), (ItemLike)RailcraftItems.BRONZE_ELECTRODE.get(), 1);
        RollingRecipePattern.line(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.COPPER_PLATE)), (ItemLike)RailcraftItems.COPPER_ELECTRODE.get(), 1);
    }

    private void buildRails() {
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "standard_rail");
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRONZE_INGOT)), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "bronze_rail");
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_INGOT)), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 12, "invar_rail");
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 16, "steel_rail");
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_COPPER)), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 6, "copper_electric_rail");
        RollingRecipePattern.parallelLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.DUSTS_REDSTONE)), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_GOLD)), (ItemLike)RailcraftItems.ADVANCED_RAIL.get(), 8, "advanced_rail");
        RollingRecipePattern.parallelThreeLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), Ingredient.of((ItemLike)Items.BLAZE_POWDER), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_GOLD)), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get(), 8, "standard_high_speed_rail");
        RollingRecipePattern.parallelThreeLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.OBSIDIAN_DUST)), Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 8, "steel_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_INGOT)), Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.OBSIDIAN_DUST)), Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_INGOT)), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 4, "invar_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_COPPER)), Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 12);
    }

    private void buildPlates() {
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_IRON)), (ItemLike)RailcraftItems.IRON_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_GOLD)), (ItemLike)RailcraftItems.GOLD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(Tags.Items.INGOTS_COPPER)), (ItemLike)RailcraftItems.COPPER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.STEEL_INGOT)), (ItemLike)RailcraftItems.STEEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.NICKEL_INGOT)), (ItemLike)RailcraftItems.NICKEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.INVAR_INGOT)), (ItemLike)RailcraftItems.INVAR_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRASS_INGOT)), (ItemLike)RailcraftItems.BRASS_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.TIN_INGOT)), (ItemLike)RailcraftItems.TIN_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.BRONZE_INGOT)), (ItemLike)RailcraftItems.BRONZE_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.LEAD_INGOT)), (ItemLike)RailcraftItems.LEAD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.SILVER_INGOT)), (ItemLike)RailcraftItems.SILVER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(this.output, Ingredient.of((HolderSet)this.items.getOrThrow(RailcraftTags.Items.ZINC_INGOT)), (ItemLike)RailcraftItems.ZINC_PLATE.get(), 4);
    }

    public static class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
            super(output, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new RollingRecipeProvider(registries, output);
        }

        public String getName() {
            return "RollingRecipeProvider";
        }
    }
}

