/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.charge.ChargeNetworkImpl;
import mods.railcraft.gui.widget.Gauge;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public class ChargeNetworkUtilizationIndicator
implements Gauge {
    @Nullable
    protected final ServerLevel level;
    protected final BlockPos pos;
    private float chargePercent;
    private final List<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>(1);

    public ChargeNetworkUtilizationIndicator(@Nullable ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    @Override
    public void refresh() {
        this.tooltip.clear();
        this.tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.literal((String)String.format("%.0f%%", (double)this.chargePercent * 100.0)).getVisualOrderText()));
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        return this.tooltip;
    }

    @Override
    public float getServerValue() {
        return ((ChargeNetworkImpl)Charge.distribution.network(this.level)).grid(this.pos).getUtilization();
    }

    @Override
    public float getClientValue() {
        return this.chargePercent;
    }

    @Override
    public void setClientValue(float value) {
        this.chargePercent = value;
    }
}

