/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.ArrayList;
import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.gui.widget.Gauge;
import mods.railcraft.util.HumanReadableNumberFormatter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;

public class EnergyStorageBatteryIndicator
implements Gauge {
    private float charge;
    private final EnergyHandler battery;
    private final List<ClientTooltipComponent> tooltip = new ArrayList<ClientTooltipComponent>(2);

    public EnergyStorageBatteryIndicator(EnergyHandler battery) {
        this.battery = battery;
    }

    @Override
    public void refresh() {
        int capacity = this.battery.getCapacityAsInt();
        float chargeLevel = this.charge * 100.0f;
        float energyStorage = this.charge * (float)capacity;
        this.tooltip.clear();
        this.tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)Translations.Tips.PERCENTAGE).withStyle(ChatFormatting.GREEN).append(CommonComponents.SPACE).append((Component)Component.literal((String)String.format("%.0f%%", Float.valueOf(chargeLevel))).withStyle(ChatFormatting.WHITE)).getVisualOrderText()));
        this.tooltip.add(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)Translations.Tips.ENERGY).withStyle(ChatFormatting.GREEN).append(CommonComponents.SPACE).append((Component)Component.literal((String)String.format("%sFE / %sFE", HumanReadableNumberFormatter.format(energyStorage), HumanReadableNumberFormatter.format(capacity))).withStyle(ChatFormatting.WHITE)).getVisualOrderText()));
    }

    @Override
    public List<ClientTooltipComponent> getTooltip() {
        return this.tooltip;
    }

    @Override
    public float getServerValue() {
        int energyStored = this.battery.getAmountAsInt();
        int capacity = this.battery.getCapacityAsInt();
        return (float)energyStored / (float)capacity;
    }

    @Override
    public float getClientValue() {
        return this.charge;
    }

    @Override
    public void setClientValue(float value) {
        this.charge = value;
    }
}

