/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.Translations;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import mods.railcraft.util.HumanReadableNumberFormatter;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.WaterCollectionModule;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.level.ServerPlayer;

public class WaterCollectionGaugeWidget
extends FluidGaugeWidget {
    private final Collection<WaterCollectionModule> modules;
    private List<Component> tooltip;

    public WaterCollectionGaugeWidget(Collection<WaterCollectionModule> modules, StandardTank tank, int x, int y, int u, int v, int w, int h) {
        super(tank, x, y, u, v, w, h);
        this.modules = modules;
    }

    @Override
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    private void refresh() {
        int count = 0;
        double temperaturePenalty = 0.0;
        double humidityMultiplier = 0.0;
        double precipitationMultiplier = 0.0;
        for (WaterCollectionModule module : this.modules) {
            WaterCollectionModule.State state = module.getState();
            if (!state.skyVisible()) continue;
            ++count;
            temperaturePenalty += state.temperaturePenalty();
            humidityMultiplier += state.humidityMultiplier();
            precipitationMultiplier += state.precipitationMultiplier();
        }
        if (count > 0) {
            humidityMultiplier /= (double)count;
            precipitationMultiplier /= (double)count;
        }
        this.tooltip = new ArrayList<Component>();
        int baseRate = (Integer)RailcraftConfig.SERVER.waterCollectionRate.get();
        this.tooltip.addAll(this.tank.getTooltip());
        this.tooltip.add((Component)Component.empty());
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_SEE_SKY, (Object[])new Object[]{HumanReadableNumberFormatter.format(count)}).withStyle(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_BASE_RATE, (Object[])new Object[]{HumanReadableNumberFormatter.format(baseRate * count)}).withStyle(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_HUMIDITY, (Object[])new Object[]{HumanReadableNumberFormatter.format(humidityMultiplier)}).withStyle(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_PRECIPITATION, (Object[])new Object[]{HumanReadableNumberFormatter.format(precipitationMultiplier)}).withStyle(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_TEMP, (Object[])new Object[]{HumanReadableNumberFormatter.format(-temperaturePenalty)}).withStyle(ChatFormatting.GRAY));
        this.tooltip.add((Component)Component.translatable((String)Translations.Screen.WATER_TANK_FINAL_RATE, (Object[])new Object[]{HumanReadableNumberFormatter.format((double)(baseRate * count) * humidityMultiplier * precipitationMultiplier - temperaturePenalty)}).withStyle(ChatFormatting.GRAY));
    }

    @Override
    public void writeToBuf(ServerPlayer player, RegistryFriendlyByteBuf out) {
        super.writeToBuf(player, out);
        this.refresh();
        out.writeVarInt(this.tooltip.size());
        this.tooltip.forEach(component -> ComponentSerialization.STREAM_CODEC.encode((Object)out, component));
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf in) {
        super.readFromBuf(in);
        this.tooltip = new ArrayList<Component>();
        int size = in.readVarInt();
        for (int i = 0; i < size; ++i) {
            this.tooltip.add((Component)ComponentSerialization.STREAM_CODEC.decode((Object)in));
        }
    }
}

