/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.jei.category;

import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.jei.RecipeTypes;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

public class CrusherRecipeCategory
extends AbstractRecipeCategory<RecipeHolder<CrusherRecipe>> {
    private static final int WIDTH = 144;
    private static final int HEIGHT = 54;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/crusher.png");
    private final IDrawable background;
    private final IDrawable arrow;

    public CrusherRecipeCategory(IGuiHelper guiHelper) {
        super(RecipeTypes.CRUSHER, (Component)Component.translatable((String)Translations.Jei.CRUSHER), guiHelper.createDrawableItemLike((ItemLike)RailcraftItems.CRUSHER.get()), 144, 54);
        this.background = guiHelper.createDrawable(BACKGROUND, 0, 171, 144, 54);
        this.arrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(BACKGROUND, 144, 171, 29, 53), 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void draw(RecipeHolder<CrusherRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        this.arrow.draw(guiGraphics, 58, 0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CrusherRecipe> recipeHolder, IFocusGroup focuses) {
        CrusherRecipe recipe = (CrusherRecipe)recipeHolder.value();
        List ingredients = recipe.placementInfo().ingredients();
        builder.addInputSlot(19, 19).add((Ingredient)ingredients.getFirst());
        List<CrusherRecipe.CrusherOutput> outputs = recipe.getProbabilityOutputs();
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int index = 1 + x + y * 3;
                ItemStack itemStack = ItemStack.EMPTY;
                if (outputs.size() > index - 1) {
                    itemStack = outputs.get(index - 1).getOutput();
                }
                IRecipeSlotBuilder recipeLayout = (IRecipeSlotBuilder)builder.addOutputSlot(91 + x * 18, y * 18 + 1).add(itemStack);
                if (itemStack.isEmpty()) continue;
                recipeLayout.addRichTooltipCallback((recipeSlotView, tooltip) -> {
                    double probability = ((CrusherRecipe.CrusherOutput)outputs.get(index - 1)).probability() * 100.0;
                    MutableComponent probText = Component.translatable((String)Translations.Jei.CRUSHER_TIP, (Object[])new Object[]{probability}).withStyle(ChatFormatting.GRAY);
                    tooltip.add((FormattedText)probText);
                });
            }
        }
    }
}

