/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.inventory.RailcraftMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.connection.ConnectionType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncWidgetMessage(int windowId, byte widgetId, byte[] rawUpdates) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncWidgetMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("sync_widget"));
    public static final StreamCodec<FriendlyByteBuf, SyncWidgetMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncWidgetMessage::windowId, (StreamCodec)ByteBufCodecs.BYTE, SyncWidgetMessage::widgetId, (StreamCodec)ByteBufCodecs.BYTE_ARRAY, SyncWidgetMessage::rawUpdates, SyncWidgetMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SyncWidgetMessage message, IPayloadContext context) {
        Player player = context.player();
        AbstractContainerMenu menu = player.containerMenu;
        if (menu instanceof RailcraftMenu) {
            RailcraftMenu railcraftMenu = (RailcraftMenu)menu;
            if (menu.containerId == message.windowId) {
                RegistryFriendlyByteBuf buff = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])message.rawUpdates)), player.registryAccess(), ConnectionType.OTHER);
                railcraftMenu.getWidgets().get(message.widgetId).readFromBuf(buff);
                buff.release();
            }
        }
    }
}

