/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import java.util.EnumSet;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.signal.ActionSignalBoxBlockEntity;
import mods.railcraft.world.level.block.entity.signal.LockableSignalBoxBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetActionSignalBoxMessage(BlockPos blockPos, EnumSet<SignalAspect> actionSignalAspects, LockableSignalBoxBlockEntity.Lock lock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetActionSignalBoxMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_action_signal_box"));
    public static final StreamCodec<FriendlyByteBuf, SetActionSignalBoxMessage> STREAM_CODEC = CustomPacketPayload.codec(SetActionSignalBoxMessage::write, SetActionSignalBoxMessage::read);

    private static SetActionSignalBoxMessage read(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.readBlockPos();
        EnumSet actionSignalAspects = buf.readEnumSet(SignalAspect.class);
        LockableSignalBoxBlockEntity.Lock lock = (LockableSignalBoxBlockEntity.Lock)buf.readEnum(LockableSignalBoxBlockEntity.Lock.class);
        return new SetActionSignalBoxMessage(blockPos, actionSignalAspects, lock);
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeEnumSet(this.actionSignalAspects, SignalAspect.class);
        buf.writeEnum((Enum)this.lock);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetActionSignalBoxMessage message, IPayloadContext context) {
        Player player = context.player();
        NameAndId senderProfile = player.nameAndId();
        Level level = player.level();
        LevelUtil.getBlockEntity((BlockGetter)level, message.blockPos, ActionSignalBoxBlockEntity.class).filter(signalBox -> signalBox.canAccess(senderProfile)).ifPresent(signalBox -> {
            signalBox.getActionSignalAspects().clear();
            signalBox.getActionSignalAspects().addAll(message.actionSignalAspects);
            signalBox.setLock(message.lock);
            signalBox.setOwner((NameAndId)(message.lock == LockableSignalBoxBlockEntity.Lock.LOCKED ? senderProfile : null));
            signalBox.syncToClient();
            signalBox.setChanged();
        });
    }
}

