/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetLocomotiveMessage(int entityId, Locomotive.Mode mode, Locomotive.Speed speed, Locomotive.Lock lock, boolean reverse) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetLocomotiveMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_locomotive"));
    public static final StreamCodec<FriendlyByteBuf, SetLocomotiveMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SetLocomotiveMessage::entityId, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Locomotive.Mode.class), SetLocomotiveMessage::mode, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Locomotive.Speed.class), SetLocomotiveMessage::speed, (StreamCodec)NeoForgeStreamCodecs.enumCodec(Locomotive.Lock.class), SetLocomotiveMessage::lock, (StreamCodec)ByteBufCodecs.BOOL, SetLocomotiveMessage::reverse, SetLocomotiveMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetLocomotiveMessage message, IPayloadContext context) {
        Locomotive locomotive;
        Player player = context.player();
        Entity entity = player.level().getEntity(message.entityId);
        if (entity instanceof Locomotive && (locomotive = (Locomotive)entity).canControl(player)) {
            Locomotive.applyAction(player, (AbstractMinecart)locomotive, false, loco -> {
                loco.setMode(message.mode);
                loco.setSpeed(message.speed);
                loco.setReverse(message.reverse);
                if (!loco.isLocked() || loco.getOwnerOrThrow().equals((Object)player.nameAndId())) {
                    loco.setLock(message.lock);
                    loco.setOwner(message.lock == Locomotive.Lock.UNLOCKED ? null : player.nameAndId());
                }
            });
        }
    }
}

