/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import java.util.EnumSet;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.world.level.block.entity.LockableSwitchTrackActuatorBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetSwitchTrackMotorMessage(BlockPos blockPos, EnumSet<SignalAspect> actionSignalAspects, boolean redstoneTriggered, LockableSwitchTrackActuatorBlockEntity.Lock lock) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetSwitchTrackMotorMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_switch_track_motor"));
    public static final StreamCodec<FriendlyByteBuf, SetSwitchTrackMotorMessage> STREAM_CODEC = CustomPacketPayload.codec(SetSwitchTrackMotorMessage::write, SetSwitchTrackMotorMessage::read);

    private static SetSwitchTrackMotorMessage read(FriendlyByteBuf buf) {
        BlockPos blockPos = buf.readBlockPos();
        EnumSet actionSignalAspects = buf.readEnumSet(SignalAspect.class);
        boolean redstoneTriggered = buf.readBoolean();
        LockableSwitchTrackActuatorBlockEntity.Lock lock = (LockableSwitchTrackActuatorBlockEntity.Lock)buf.readEnum(LockableSwitchTrackActuatorBlockEntity.Lock.class);
        return new SetSwitchTrackMotorMessage(blockPos, actionSignalAspects, redstoneTriggered, lock);
    }

    private void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.blockPos);
        buf.writeEnumSet(this.actionSignalAspects, SignalAspect.class);
        buf.writeBoolean(this.redstoneTriggered);
        buf.writeEnum((Enum)this.lock);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetSwitchTrackMotorMessage message, IPayloadContext context) {
        Player player = context.player();
        Level level = player.level();
        NameAndId senderProfile = player.nameAndId();
        level.getBlockEntity(message.blockPos, (BlockEntityType)RailcraftBlockEntityTypes.SWITCH_TRACK_MOTOR.get()).filter(switchTrack -> switchTrack.canAccess(senderProfile)).ifPresent(switchTrack -> {
            switchTrack.getActionSignalAspects().clear();
            switchTrack.getActionSignalAspects().addAll(message.actionSignalAspects);
            switchTrack.setRedstoneTriggered(message.redstoneTriggered);
            switchTrack.setLock(message.lock.equals(LockableSwitchTrackActuatorBlockEntity.Lock.UNLOCKED) ? null : senderProfile);
            switchTrack.syncToClient();
            switchTrack.setChanged();
        });
    }
}

