/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.season;

import java.time.LocalDate;
import java.time.Month;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.client.renderer.entity.state.RailcraftMinecartRenderState;
import mods.railcraft.season.Season;
import mods.railcraft.world.entity.vehicle.SeasonalCart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.entity.state.MinecartRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.Nullable;

public final class Seasons {
    private static final boolean HARVEST;
    private static final boolean HALLOWEEN;
    private static final boolean CHRISTMAS;
    public static final String GHOST_TRAIN = "Ghost Train";
    public static final String POLAR_EXPRESS = "Polar Express";

    public static boolean isGhostTrain(MinecartRenderState state) {
        Season season = Seasons.getSeason(state);
        if (season == Season.DEFAULT) {
            return (Boolean)RailcraftConfig.CLIENT.ghostTrainEnabled.get() != false && HALLOWEEN || state.nameTag != null && GHOST_TRAIN.equals(state.nameTag.getString());
        }
        return season == Season.HALLOWEEN;
    }

    public static boolean isPolarExpress(MinecartRenderState state) {
        Season season = Seasons.getSeason(state);
        ClientLevel level = Minecraft.getInstance().level;
        BlockPos pos = BlockPos.containing((double)state.x, (double)state.y, (double)state.z);
        return Seasons.isPolarExpress(season, state.nameTag, (Level)level, pos);
    }

    public static boolean isPolarExpress(AbstractMinecart cart) {
        Season season;
        if (cart instanceof SeasonalCart) {
            SeasonalCart seasonal = (SeasonalCart)cart;
            season = seasonal.getSeason();
        } else {
            season = Season.DEFAULT;
        }
        Season season2 = season;
        ClientLevel level = Minecraft.getInstance().level;
        return Seasons.isPolarExpress(season2, cart.getCustomName(), (Level)level, cart.blockPosition());
    }

    private static boolean isPolarExpress(Season season, @Nullable Component nameTag, Level level, BlockPos pos) {
        if (season == Season.DEFAULT) {
            return (Boolean)RailcraftConfig.CLIENT.polarExpressEnabled.get() != false && CHRISTMAS || nameTag != null && POLAR_EXPRESS.equals(nameTag.getString()) || ((Biome)level.getBiome(pos).value()).shouldSnow((LevelReader)level, pos);
        }
        return season == Season.CHRISTMAS;
    }

    private static Season getSeason(MinecartRenderState state) {
        if (state instanceof RailcraftMinecartRenderState) {
            RailcraftMinecartRenderState renderState = (RailcraftMinecartRenderState)state;
            return renderState.season;
        }
        return Season.DEFAULT;
    }

    public static boolean isHalloween() {
        return HALLOWEEN;
    }

    static {
        if (((Boolean)RailcraftConfig.COMMON.seasonsEnabled.get()).booleanValue()) {
            LocalDate date = LocalDate.now();
            Month month = date.getMonth();
            int day = date.getDayOfMonth();
            CHRISTMAS = switch ((Integer)RailcraftConfig.COMMON.christmas.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.DECEMBER || month == Month.JANUARY;
            };
            HARVEST = switch ((Integer)RailcraftConfig.COMMON.harvest.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.OCTOBER || month == Month.NOVEMBER;
            };
            HALLOWEEN = switch ((Integer)RailcraftConfig.COMMON.halloween.get()) {
                case 1 -> true;
                case 2 -> false;
                default -> month == Month.OCTOBER && day >= 21 || month == Month.NOVEMBER && day <= 10;
            };
        } else {
            HARVEST = false;
            HALLOWEEN = false;
            CHRISTMAS = false;
        }
    }
}

