/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.api.item.Filter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerTools {
    public static int[] buildSlotArray(int start, int size) {
        return IntStream.range(0, size).map(i -> start + i).toArray();
    }

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack.getCount() == 1) {
            return stack.getItem().getCraftingRemainder(stack);
        }
        stack.split(1);
        return stack;
    }

    public static void dropIfInvalid(Level level, BlockPos blockPos, Container container, int index) {
        ContainerTools.drop(level, blockPos, container, index, item -> container.canPlaceItem(index, item));
    }

    public static void drop(Level level, BlockPos blockPos, Container container, int index, Predicate<ItemStack> predicate) {
        ItemStack item = container.getItem(index);
        if (!item.isEmpty() && !predicate.test(item)) {
            container.setItem(index, ItemStack.EMPTY);
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)item);
        }
    }

    public static boolean matchesFilter(ItemStack filter, ItemStack stack) {
        if (stack.isEmpty() || filter.isEmpty()) {
            return false;
        }
        Item item = filter.getItem();
        if (item instanceof Filter) {
            Filter filterItem = (Filter)item;
            return filterItem.matches(filter, stack);
        }
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)filter);
    }

    public static boolean isItemStackBlock(ItemStack itemStack, Block block) {
        BlockItem item;
        Item item2;
        return !itemStack.isEmpty() && (item2 = itemStack.getItem()) instanceof BlockItem && (item = (BlockItem)item2).getBlock() == block;
    }

    public static Block getBlockFromStack(ItemStack stack) {
        Block block;
        if (stack.isEmpty()) {
            return Blocks.AIR;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            block = blockItem.getBlock();
        } else {
            block = Blocks.AIR;
        }
        return block;
    }

    public static BlockState getBlockStateFromStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return Blocks.AIR.defaultBlockState();
        }
        return ContainerTools.getBlockFromStack(stack).defaultBlockState();
    }

    @Nullable
    public static BlockState getBlockStateFromStack(ItemStack stack, Level level, BlockPos pos) {
        if (stack.isEmpty()) {
            return null;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock().getStateForPlacement(new BlockPlaceContext(level, null, InteractionHand.MAIN_HAND, stack, new BlockHitResult(new Vec3(0.5, 0.5, 0.5), Direction.UP, pos.above(), false)));
        }
        return null;
    }

    public static boolean isStackFull(ItemStack stack) {
        return !stack.isEmpty() && stack.getCount() == stack.getMaxStackSize();
    }
}

