/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.container;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.container.manipulator.ContainerManipulator;
import mods.railcraft.api.item.MinecartFactory;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.item.CartItem;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import org.jetbrains.annotations.Nullable;

public enum StackFilter implements Predicate<ItemStack>
{
    FUEL(itemStack -> Minecraft.getInstance().level.fuelValues().isFuel(itemStack)),
    TRACK(TrackUtil::isRail),
    MINECART(itemStack -> {
        Item item = itemStack.getItem();
        return item instanceof MinecartItem || item instanceof MinecartFactory || item instanceof CartItem;
    }),
    BALLAST(itemStack -> ContainerTools.getBlockFromStack(itemStack).builtInRegistryHolder().is(RailcraftTags.Blocks.BALLAST)),
    FLUID_CONTAINER(itemStack -> ItemAccess.forStack((ItemStack)itemStack).getCapability(Capabilities.Fluid.ITEM) != null),
    FEED(itemStack -> itemStack.is(Tags.Items.ANIMAL_FOODS) || ContainerTools.getBlockFromStack(itemStack) instanceof StemBlock),
    CARGO(itemStack -> {
        if (!((Boolean)RailcraftConfig.SERVER.chestAllowFluids.get()).booleanValue() && FluidTools.isFluidHandler(itemStack)) {
            return false;
        }
        return !((List)RailcraftConfig.SERVER.cargoBlacklist.get()).contains(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString());
    }),
    DYES(itemStack -> itemStack.is(Tags.Items.DYES)),
    RAW_METAL(itemStack -> itemStack.is(RailcraftTags.Items.METAL));

    private final Predicate<ItemStack> predicate;

    private StackFilter(Predicate<ItemStack> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return !itemStack.isEmpty() && this.predicate.test(itemStack);
    }

    public static Predicate<ItemStack> of(Class<?> itemClass) {
        return itemStack -> !itemStack.isEmpty() && itemClass.isAssignableFrom(itemStack.getItem().getClass());
    }

    public static Predicate<ItemStack> of(Item item) {
        return itemStack -> !itemStack.isEmpty() && itemStack.is(item);
    }

    public static Predicate<ItemStack> of(Block block) {
        return itemStack -> !itemStack.isEmpty() && itemStack.is(block.asItem());
    }

    public static Predicate<ItemStack> anyMatch(ItemStack ... filters) {
        return StackFilter.anyMatch(Arrays.asList(filters));
    }

    public static Predicate<ItemStack> anyMatch(Collection<ItemStack> filters) {
        return itemStack -> filters.stream().anyMatch(f -> ContainerTools.matchesFilter(f, itemStack));
    }

    public static Predicate<ItemStack> anyMatch(ContainerManipulator<?> inv) {
        return itemStack -> inv.streamItems().anyMatch(f -> ContainerTools.matchesFilter(f, itemStack));
    }

    public static Predicate<ItemStack> none() {
        return itemStack -> false;
    }

    public static Predicate<ItemStack> noneOf(ItemStack ... stacks) {
        return StackFilter.noneOf(Arrays.asList(stacks));
    }

    public static Predicate<ItemStack> noneOf(Collection<ItemStack> stacks) {
        return itemStack -> {
            if (itemStack.isEmpty()) {
                return false;
            }
            return stacks.stream().filter(toTest -> !toTest.isEmpty()).noneMatch(filter -> ItemStack.isSameItem((ItemStack)itemStack, (ItemStack)filter));
        };
    }

    public static Predicate<ItemStack> ofSize(int size) {
        return itemStack -> itemStack.getCount() == size;
    }

    public static Predicate<ItemStack> singleton() {
        return itemStack -> itemStack.getCount() == 1;
    }

    public static Predicate<ItemStack> nonEmpty() {
        return itemStack -> !itemStack.isEmpty();
    }

    public static Predicate<ItemStack> isCart(@Nullable AbstractMinecart cart) {
        return itemStack -> {
            if (itemStack.isEmpty()) {
                return false;
            }
            if (cart == null) {
                return false;
            }
            ItemStack cartItem = cart.getPickResult();
            boolean matches = ItemStack.isSameItem((ItemStack)cartItem, (ItemStack)itemStack);
            if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                return matches && itemStack.getHoverName().equals((Object)cart.getCustomName());
            }
            return matches;
        };
    }
}

