/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.fluids;

import java.util.stream.IntStream;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class AdvancedFluidHandler
implements ResourceHandler<FluidResource> {
    private final ResourceHandler<FluidResource> fluidHandler;

    public AdvancedFluidHandler(ResourceHandler<FluidResource> fluidHandler) {
        this.fluidHandler = fluidHandler;
    }

    public int size() {
        return this.fluidHandler.size();
    }

    public FluidResource getResource(int index) {
        return (FluidResource)this.fluidHandler.getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.fluidHandler.getAmountAsLong(index);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.fluidHandler.getCapacityAsLong(index, (Resource)resource);
    }

    public boolean isValid(int index, FluidResource resource) {
        return this.fluidHandler.isValid(index, (Resource)resource);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return this.fluidHandler.insert(index, (Resource)resource, amount, transaction);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        return this.fluidHandler.extract(index, (Resource)resource, amount, transaction);
    }

    public int extract(FluidResource resource, int amount, TransactionContext transaction) {
        return this.fluidHandler.extract((Resource)resource, amount, transaction);
    }

    public int getFluidQty(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return 0;
        }
        return IntStream.range(0, this.size()).mapToObj(i -> FluidUtil.getStack((ResourceHandler)this, (int)i)).filter(fluidStack -> FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)fluid)).mapToInt(FluidStack::getAmount).sum();
    }

    public boolean isTankEmpty(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return this.areTanksEmpty();
        }
        return this.getFluidQty(fluid) <= 0;
    }

    public boolean isTankFull(FluidStack fluid) {
        if (fluid.isEmpty()) {
            return this.areTanksFull();
        }
        try (Transaction transaction = Transaction.openRoot();){
            int filled = this.insert((Resource)FluidResource.of((FluidStack)fluid), 1, (TransactionContext)transaction);
            boolean bl = filled <= 0;
            return bl;
        }
    }

    public boolean areTanksFull() {
        for (int i = 0; i < this.size(); ++i) {
            FluidStack tank = FluidUtil.getStack((ResourceHandler)this, (int)i);
            if (!tank.isEmpty() && tank.getAmount() >= this.getCapacityAsInt(i, (Resource)FluidResource.EMPTY)) continue;
            return false;
        }
        return true;
    }

    public boolean areTanksEmpty() {
        return !this.isFluidInTank();
    }

    public boolean isFluidInTank() {
        for (int i = 0; i < this.size(); ++i) {
            boolean empty;
            FluidStack tank = FluidUtil.getStack((ResourceHandler)this, (int)i);
            boolean bl = empty = tank.isEmpty() || tank.getAmount() <= 0;
            if (empty) continue;
            return true;
        }
        return false;
    }

    public float getFluidLevel() {
        int amount = 0;
        int capacity = 0;
        for (int i = 0; i < this.size(); ++i) {
            FluidStack liquid = FluidUtil.getStack((ResourceHandler)this, (int)i);
            amount += liquid.isEmpty() ? 0 : liquid.getAmount();
            capacity += this.getCapacityAsInt(i, (Resource)FluidResource.EMPTY);
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public float getFluidLevel(FluidStack fluid) {
        int amount = 0;
        int capacity = 0;
        for (int i = 0; i < this.size(); ++i) {
            FluidStack liquid = FluidUtil.getStack((ResourceHandler)this, (int)i);
            if (liquid.isEmpty() || !FluidStack.isSameFluidSameComponents((FluidStack)liquid, (FluidStack)fluid)) continue;
            amount += liquid.getAmount();
            capacity += this.getCapacityAsInt(i, (Resource)FluidResource.EMPTY);
        }
        return capacity == 0 ? 0.0f : (float)amount / (float)capacity;
    }

    public boolean canPutFluid(FluidResource fluidResource, int amount) {
        if (amount <= 0) {
            return false;
        }
        try (Transaction transaction = Transaction.openRoot();){
            boolean bl = this.insert((Resource)fluidResource, amount, (TransactionContext)transaction) > 0;
            return bl;
        }
    }
}

