/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity;

import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.item.CrackedFirestoneItem;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.RitualBlock;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class FirestoneItemEntity
extends ItemEntity {
    private int clock;
    private boolean refined;

    public FirestoneItemEntity(EntityType<? extends FirestoneItemEntity> type, Level level) {
        super(type, level);
        this.setExtendedLifetime();
        this.setDeltaMovement(this.random.nextDouble() * 0.2 - 0.1, 0.2, this.random.nextDouble() * 0.2 - 0.1);
    }

    public FirestoneItemEntity(Level level, Vec3 position, ItemStack itemStack) {
        this((EntityType<? extends FirestoneItemEntity>)((EntityType)RailcraftEntityTypes.FIRESTONE.get()), level);
        this.setPos(position.x, position.y, position.z);
        this.setItem(itemStack);
        this.lifespan = itemStack.getEntityLifespan(level);
    }

    public void tick() {
        FirestoneItem item;
        Item item2;
        super.tick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (++this.clock % 4 == 0 && (item2 = this.getItem().getItem()) instanceof FirestoneItem && (item = (FirestoneItem)item2).spawnsFire() && serverLevel.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK)) {
            FirestoneItem.trySpawnFire(serverLevel, this.blockPosition(), this.getItem(), this.getOwner());
        }
    }

    public void lavaHurt() {
        Level level;
        if (!(this.refined && this.isAlive() && (level = this.level()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState firestoneBlock = ((RitualBlock)((Object)RailcraftBlocks.RITUAL.get())).defaultBlockState();
        BlockPos surface = this.blockPosition();
        if (!serverLevel.getFluidState(surface).is(FluidTags.LAVA) && !serverLevel.getFluidState(surface.above()).is(FluidTags.LAVA)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            BlockEntity blockEntity;
            boolean cracked;
            if (!serverLevel.getBlockState(surface = surface.above()).isAir() || !serverLevel.getFluidState(surface.below()).is(FluidTags.LAVA) || !LevelUtil.setBlockState((Level)serverLevel, surface, (BlockState)firestoneBlock.setValue((Property)RitualBlock.CRACKED, (Comparable)Boolean.valueOf(cracked = this.getItem().getItem() instanceof CrackedFirestoneItem)), this.getOwner()) || !((blockEntity = serverLevel.getBlockEntity(surface)) instanceof RitualBlockEntity)) continue;
            RitualBlockEntity fireEntity = (RitualBlockEntity)blockEntity;
            ItemStack firestone = this.getItem();
            fireEntity.setCharge(firestone.getMaxDamage() - firestone.getDamageValue());
            if (firestone.has(DataComponents.CUSTOM_NAME)) {
                fireEntity.setItemName(firestone.getDisplayName());
            }
            this.kill(serverLevel);
            return;
        }
    }

    public void setRefined(boolean refined) {
        this.refined = refined;
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putBoolean("refined", this.refined);
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.refined = valueInput.getBooleanOr("refined", false);
    }
}

