/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;

public abstract class MaintenancePatternMinecart
extends MaintenanceMinecart
implements WorldlyContainer {
    protected final AdvancedContainer patternContainer = new AdvancedContainer(6).listener((Container)this);

    protected MaintenancePatternMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected MaintenancePatternMinecart(ItemStack itemStack, EntityType<?> type, Level level, double x, double y, double z) {
        super(itemStack, type, level, x, y, z);
    }

    public Container getPattern() {
        return this.patternContainer;
    }

    @Override
    public int getContainerSize() {
        return 1;
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return false;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        return this.canPlaceItem(slot, stack);
    }

    protected void stockItems(int slotReplace, int slotStock) {
        ItemStack stackReplace = this.patternContainer.getItem(slotReplace);
        ItemStack stackStock = this.getItem(slotStock);
        RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
        if (!stackStock.isEmpty() && !ItemStack.isSameItem((ItemStack)stackReplace, (ItemStack)stackStock)) {
            rollingStock.offerOrDropItem(stackStock);
            this.setItem(slotStock, ItemStack.EMPTY);
            stackStock = ItemStack.EMPTY;
        }
        if (stackReplace.isEmpty()) {
            return;
        }
        if (!ContainerTools.isStackFull(stackStock) && stackStock.getCount() < this.getMaxStackSize()) {
            this.setItem(slotStock, stackReplace.copyWithCount(stackStock.getCount() + rollingStock.pullItem(x -> ItemStack.isSameItem((ItemStack)stackReplace, (ItemStack)x)).getCount()));
        }
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.putChild("pattern", (ValueIOSerializable)this.patternContainer);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        valueInput.readChild("pattern", (ValueIOSerializable)this.patternContainer);
    }
}

