/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.Optional;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.FluidTransferHandler;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.network.RailcraftDataSerializers;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.FilteredMinecart;
import mods.railcraft.world.inventory.TankMinecartMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.level.material.StandardTank;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;

public class TankMinecart
extends FilteredMinecart
implements WorldlyContainer,
FluidTransferHandler {
    private static final EntityDataAccessor<CompoundTag> FLUID_STACK = SynchedEntityData.defineId(TankMinecart.class, RailcraftDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> FILLING = SynchedEntityData.defineId(TankMinecart.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_PROCESSING = 1;
    public static final int SLOT_OUTPUT = 2;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 3);
    private final StandardTank tank;
    private final ContainerMapper invLiquids;
    private int fluidProcessingTimer;
    private FluidTools.ProcessState processState;

    public TankMinecart(EntityType<?> type, Level level) {
        super(type, level);
        this.tank = StandardTank.ofBuckets((Integer)RailcraftConfig.SERVER.tankCartFluidCapacity.get()).changeCallback(this::tankChanged).setValidator(fluidStack -> this.getFilterFluid().map(arg_0 -> ((FluidResource)fluidStack).matches(arg_0)).orElse(true));
        this.invLiquids = ContainerMapper.make((Container)this).ignoreItemChecks();
        this.processState = FluidTools.ProcessState.RESET;
    }

    public TankMinecart(ItemStack itemStack, Level level, double x, double y, double z) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TANK_MINECART.get(), level, x, y, z);
        this.tank = StandardTank.ofBuckets((Integer)RailcraftConfig.SERVER.tankCartFluidCapacity.get()).changeCallback(this::tankChanged).setValidator(fluidStack -> this.getFilterFluid().map(arg_0 -> ((FluidResource)fluidStack).matches(arg_0)).orElse(true));
        this.invLiquids = ContainerMapper.make((Container)this).ignoreItemChecks();
        this.processState = FluidTools.ProcessState.RESET;
        this.loadFromItemStack(itemStack);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLUID_STACK, (Object)new CompoundTag());
        builder.define(FILLING, (Object)false);
    }

    private void tankChanged() {
        CompoundTag tag = new CompoundTag();
        tag.store("tank", FluidStack.OPTIONAL_CODEC, (Object)this.tank.getFluidStack());
        this.entityData.set(FLUID_STACK, (Object)tag);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (key.equals(FLUID_STACK)) {
            FluidStack fluidStack = (FluidStack)((CompoundTag)this.entityData.get(FLUID_STACK)).read("tank", FluidStack.OPTIONAL_CODEC).orElseThrow();
            this.tank.setFluid(fluidStack);
        }
    }

    public StandardTank getTankManager() {
        return this.tank;
    }

    @Override
    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        Containers.dropContents((Level)this.level(), (Entity)this, (Container)this.invLiquids);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            return;
        }
        ContainerTools.dropIfInvalid(this.level(), this.blockPosition(), (Container)this, 0);
        ContainerTools.drop(this.level(), this.blockPosition(), (Container)this, 1, FluidTools::isFluidHandler);
        ContainerTools.drop(this.level(), this.blockPosition(), (Container)this, 2, FluidTools::isFluidHandler);
        if (this.fluidProcessingTimer++ >= 8) {
            this.fluidProcessingTimer = 0;
            this.processState = FluidTools.processContainer(this.invLiquids, this.tank, FluidTools.ProcessType.DRAIN_THEN_FILL, this.processState);
        }
    }

    @Override
    public InteractionResult interact(Player player, InteractionHand hand) {
        if (FluidTools.interactWithFluidHandler(player, hand, (ResourceHandler<FluidResource>)this.getTankManager())) {
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public int getContainerSize() {
        return 3;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueInput) {
        super.readAdditionalSaveData(valueInput);
        this.processState = valueInput.read("processState", FluidTools.ProcessState.CODEC).orElse(FluidTools.ProcessState.RESET);
        valueInput.readChild("tank", (ValueIOSerializable)this.tank);
        this.tankChanged();
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueOutput) {
        super.addAdditionalSaveData(valueOutput);
        valueOutput.store("processState", FluidTools.ProcessState.CODEC, (Object)this.processState);
        valueOutput.putChild("tank", (ValueIOSerializable)this.tank);
    }

    public boolean isFilling() {
        return (Boolean)this.entityData.get(FILLING);
    }

    @Override
    public void setFilling(boolean filling) {
        this.entityData.set(FILLING, (Object)filling);
    }

    public Optional<FluidStack> getFilterFluid() {
        if (this.getFilterItem().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(FluidUtil.getFirstStackContained((ItemStack)this.getFilterItem()));
    }

    public Container getInvLiquids() {
        return this.invLiquids;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot == 0 && FluidTools.isFluidHandler(stack);
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return slot == 2;
    }

    @Override
    public boolean canPassFluidRequests(FluidStack fluid) {
        return this.getFilterFluid().map(filter -> FluidStack.isSameFluidSameComponents((FluidStack)filter, (FluidStack)fluid)).orElseGet(() -> this.tank.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)this.tank.getFluidStack(), (FluidStack)fluid));
    }

    @Override
    public boolean canAcceptPushedFluid(RollingStock requester, FluidStack fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Override
    public boolean canProvidePulledFluid(RollingStock requester, FluidStack fluid) {
        return this.canPassFluidRequests(fluid);
    }

    @Override
    public ItemStack getPickResult() {
        ItemStack itemStack = super.getPickResult();
        if (!this.tank.isEmpty()) {
            itemStack.set(RailcraftDataComponents.FLUID, (Object)SimpleFluidContent.copyOf((FluidStack)this.tank.getFluidStack()));
        }
        return itemStack;
    }

    @Override
    protected void loadFromItemStack(ItemStack itemStack) {
        super.loadFromItemStack(itemStack);
        if (itemStack.has(RailcraftDataComponents.FLUID)) {
            this.tank.setFluid(((SimpleFluidContent)itemStack.get(RailcraftDataComponents.FLUID)).copy());
        }
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.TANK_MINECART.get();
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new TankMinecartMenu(id, playerInventory, this);
    }
}

