/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Train;
import mods.railcraft.attachment.RailcraftAttachmentTypes;
import mods.railcraft.util.FunctionalUtil;
import mods.railcraft.world.entity.vehicle.RollingStockImpl;
import mods.railcraft.world.entity.vehicle.WeightedCart;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.core.UUIDUtil;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.CombinedResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;

public final class TrainImpl
implements Train {
    private final UUID id;
    private final RollingStockImpl front;
    private final Set<UUID> locks = new HashSet<UUID>();
    private Train.State state = Train.State.NORMAL;

    static TrainImpl create(RollingStockImpl owner) {
        return new TrainImpl(UUID.randomUUID(), owner);
    }

    private TrainImpl(UUID id, RollingStockImpl front) {
        this.id = id;
        this.front = front;
    }

    @Override
    public UUID id() {
        return this.id;
    }

    @Override
    public Train.State state() {
        return this.state;
    }

    @Override
    public void setState(Train.State state) {
        if (this.state != state) {
            this.state = state;
        }
    }

    @Override
    public RollingStock front() {
        return this.front;
    }

    @Override
    public void copyTo(Train train) {
        this.locks.forEach(train::addLock);
        train.setStateIfHigherPriority(this.state);
    }

    @Override
    public int getNumRunningLocomotives() {
        return (int)this.entities().flatMap(FunctionalUtil.ofType(Locomotive.class)).filter(Locomotive::isRunning).count();
    }

    @Override
    public Optional<ResourceHandler<ItemResource>> itemHandler() {
        List cartHandlers = this.entities().flatMap(cart -> Optional.ofNullable((ResourceHandler)cart.getCapability(Capabilities.Item.ENTITY)).stream()).toList();
        return cartHandlers.isEmpty() ? Optional.empty() : Optional.of(new CombinedResourceHandler(cartHandlers));
    }

    @Override
    public Optional<ResourceHandler<FluidResource>> fluidHandler() {
        List cartHandlers = this.entities().flatMap(cart -> Optional.ofNullable((ResourceHandler)cart.getCapability(Capabilities.Fluid.ENTITY, null)).stream()).toList();
        return cartHandlers.isEmpty() ? Optional.empty() : Optional.of(new CombinedResourceHandler(cartHandlers));
    }

    public void refreshMaxSpeed() {
        this.setMaxSpeed(this.calculateMaxSpeed());
    }

    private float calculateMaxSpeed() {
        double locoBoost = Math.max(0.0, (double)this.getNumRunningLocomotives() - 1.0) * 0.075;
        return (float)this.entities().mapToDouble(c -> {
            Float maxCartSpeedOnRail = (Float)c.getData(RailcraftAttachmentTypes.MAX_CART_SPEED_ON_RAIL);
            return Math.min((double)maxCartSpeedOnRail.floatValue(), (double)this.softMaxSpeed((AbstractMinecart)c) + locoBoost);
        }).min().orElse(1.2f);
    }

    private float softMaxSpeed(AbstractMinecart cart) {
        float f;
        if (cart instanceof WeightedCart) {
            WeightedCart weighted = (WeightedCart)cart;
            f = weighted.softMaxSpeed();
        } else {
            f = ((Float)cart.getData(RailcraftAttachmentTypes.MAX_CART_SPEED_ON_RAIL)).floatValue();
        }
        return f;
    }

    private void setMaxSpeed(float trainSpeed) {
        this.entities().forEach(c -> c.setData(RailcraftAttachmentTypes.CURRENT_SPEED_CAP_ON_RAIL, (Object)Float.valueOf(trainSpeed)));
    }

    @Override
    public boolean isLocked() {
        return !this.locks.isEmpty();
    }

    @Override
    public void addLock(UUID lock) {
        this.locks.add(lock);
    }

    @Override
    public void removeLock(UUID lock) {
        this.locks.remove(lock);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrainImpl)) {
            return false;
        }
        TrainImpl other = (TrainImpl)obj;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return String.format("Train{id=%s}", this.id);
    }

    static TrainImpl deserialize(ValueInput input, RollingStockImpl minecart) {
        UUID id = (UUID)input.read("id", UUIDUtil.CODEC).orElseThrow();
        TrainImpl train = new TrainImpl(id, minecart);
        input.read("state", Train.State.CODEC).ifPresent(train::setState);
        input.read("locks", UUIDUtil.CODEC.listOf()).ifPresent(train.locks::addAll);
        return train;
    }

    void serialize(ValueOutput valueOutput) {
        valueOutput.store("id", UUIDUtil.CODEC, (Object)this.id);
        valueOutput.store("state", Train.State.CODEC, (Object)this.state);
        valueOutput.store("locks", UUIDUtil.CODEC.listOf(), new ArrayList<UUID>(this.locks));
    }
}

