/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.world.entity.vehicle.TunnelBore;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class TunnelBorePart
extends PartEntity<TunnelBore> {
    private final float forwardOffset;
    private final float sideOffset;
    private final EntityDimensions size;

    public TunnelBorePart(TunnelBore parent, float width, float height, float forwardOffset) {
        this(parent, width, height, forwardOffset, 0.0f);
    }

    public TunnelBorePart(TunnelBore parent, float width, float height, float forwardOffset, float sideOffset) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.refreshDimensions();
        this.forwardOffset = forwardOffset;
        this.sideOffset = sideOffset;
        this.updatePosition();
    }

    public EntityDimensions getDimensions(Pose pose) {
        return this.size;
    }

    public void tick() {
        super.tick();
        this.updatePosition();
    }

    private void updatePosition() {
        double x = ((TunnelBore)this.getParent()).getOffsetX(((TunnelBore)this.getParent()).getX(), this.forwardOffset, this.sideOffset);
        double z = ((TunnelBore)this.getParent()).getOffsetZ(((TunnelBore)this.getParent()).getZ(), this.forwardOffset, this.sideOffset);
        this.snapTo(x, ((TunnelBore)this.getParent()).getY() + (double)0.3f, z, 0.0f, 0.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(ValueInput valueInput) {
    }

    protected void addAdditionalSaveData(ValueOutput valueOutput) {
    }

    public boolean canBeCollidedWith(@Nullable Entity entity) {
        return true;
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        if (!this.isInvulnerableToBase(damageSource)) {
            ((TunnelBore)this.getParent()).attackEntityFromPart(this, damageSource, amount);
            return true;
        }
        return false;
    }

    public boolean is(Entity entity) {
        return this == entity || this.getParent() == entity;
    }
}

