/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle.locomotive;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.locomotive.BaseSteamLocomotive;
import mods.railcraft.world.inventory.SteamLocomotiveMenu;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.TicketItem;
import mods.railcraft.world.level.material.steam.SolidFuelProvider;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class SteamLocomotive
extends BaseSteamLocomotive
implements WorldlyContainer {
    private static final int FUEL_SLOT = 3;
    private static final int EXTRA_FUEL_SLOT_A = 4;
    private static final int EXTRA_FUEL_SLOT_B = 5;
    private static final int EXTRA_FUEL_SLOT_C = 6;
    private static final int TICKET_SLOT = 7;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 7);
    private final ContainerMapper fuelContainer = ContainerMapper.make((Container)this, 3, 1);
    private final ContainerMapper extraFuelContainer = ContainerMapper.make((Container)this, 4, 3);
    private final ContainerMapper allFuelContainer = ContainerMapper.make((Container)this, 3, 4);
    private final ContainerMapper ticketContainer = new ContainerMapper((Container)this, 7, 2).ignoreItemChecks();

    public SteamLocomotive(EntityType<?> type, Level level) {
        super(type, level);
        this.boiler().setFuelProvider(new SolidFuelProvider((Container)this, 3){

            @Override
            public float consumeFuel() {
                return SteamLocomotive.this.isShutdown() ? 0.0f : super.consumeFuel();
            }
        });
    }

    public SteamLocomotive(ItemStack itemStack, Level level, double x, double y, double z) {
        super(itemStack, (EntityType)RailcraftEntityTypes.STEAM_LOCOMOTIVE.get(), level, x, y, z);
        this.loadFromItemStack(itemStack);
        this.boiler().setFuelProvider(new SolidFuelProvider((Container)this, 3){

            @Override
            public float consumeFuel() {
                return SteamLocomotive.this.isShutdown() ? 0.0f : super.consumeFuel();
            }
        });
    }

    @Override
    protected DyeColor getDefaultPrimaryColor() {
        return DyeColor.LIGHT_GRAY;
    }

    @Override
    protected DyeColor getDefaultSecondaryColor() {
        return DyeColor.GRAY;
    }

    @Override
    protected void serverTick(ServerLevel level) {
        FluidStack pulledWater;
        super.serverTick(level);
        this.extraFuelContainer.moveOneItemTo(this.fuelContainer);
        RollingStock rollingStock = RollingStock.getOrThrow((AbstractMinecart)this);
        ItemStack pulledFuel = rollingStock.pullItem(this.extraFuelContainer::canFit);
        if (!pulledFuel.isEmpty()) {
            this.extraFuelContainer.insert(pulledFuel);
        }
        if (this.isSafeToFill() && this.waterTank.getFluidAmount() < this.waterTank.getCapacity() / 2 && !(pulledWater = rollingStock.pullFluid(new FluidStack((Fluid)Fluids.WATER, ((Integer)RailcraftConfig.SERVER.tankCartFluidTransferRate.get()).intValue()))).isEmpty()) {
            try (Transaction tx = Transaction.openRoot();){
                this.waterTank.insert(FluidResource.of((FluidStack)pulledWater), pulledWater.getAmount(), (TransactionContext)tx);
                tx.commit();
            }
        }
    }

    @Override
    public boolean needsFuel() {
        FluidStack water = this.waterTank.getFluidStack();
        if (water.isEmpty() || water.getAmount() < this.waterTank.getCapacity() / 3) {
            return true;
        }
        int numItems = this.allFuelContainer.countItems(item -> item.getBurnTime(null, this.level().fuelValues()) > 0);
        if (numItems == 0) {
            return true;
        }
        int maxItems = this.allFuelContainer.countMaxItemStackSize();
        return (float)numItems / (float)maxItems < 0.25f;
    }

    @Override
    protected Container ticketContainer() {
        return this.ticketContainer;
    }

    public ResourceHandler<ItemResource> getFuelContainer() {
        return VanillaContainerWrapper.of((Container)this.allFuelContainer);
    }

    @Override
    public int getContainerSize() {
        return 9;
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction side) {
        return this.canPlaceItem(slot, stack);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction side) {
        return slot < 7;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return switch (slot) {
            case 3, 4, 5, 6 -> {
                if (stack.getBurnTime(null, this.level().fuelValues()) > 0) {
                    yield true;
                }
                yield false;
            }
            case 0 -> FluidTools.containsFluid(stack, (Fluid)Fluids.WATER);
            case 7 -> TicketItem.FILTER.test(stack);
            default -> false;
        };
    }

    @Override
    public boolean canAcceptPushedItem(RollingStock requester, ItemStack stack) {
        return stack.getBurnTime(null, this.level().fuelValues()) > 0;
    }

    protected AbstractContainerMenu createMenu(int id, Inventory playerInventory) {
        return new SteamLocomotiveMenu(id, playerInventory, this);
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.STEAM_LOCOMOTIVE.get();
    }
}

