/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import java.util.Collections;
import mods.railcraft.Translations;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.slot.ItemFilterSlot;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import mods.railcraft.world.inventory.slot.UnmodifiableSlot;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Nullable;

public abstract class LocomotiveMenu<T extends Locomotive>
extends RailcraftMenu {
    public static final int DEFAULT_HEIGHT = 161;
    private final T locomotive;

    public LocomotiveMenu(@Nullable MenuType<?> type, int id, Inventory playerInv, T locomotive) {
        this(type, id, playerInv, locomotive, 161);
    }

    protected LocomotiveMenu(@Nullable MenuType<?> type, int id, Inventory playerInv, T locomotive, int guiHeight) {
        super(type, id, playerInv.player, arg_0 -> locomotive.stillValid(arg_0));
        this.locomotive = locomotive;
        RailcraftSlot slotTicket = new ItemFilterSlot(TicketItem.FILTER, (Container)locomotive, ((Locomotive)locomotive).getContainerSize() - 2, 116, guiHeight - 111).setStackLimit(1);
        slotTicket.setTooltip(Collections.singletonList(ClientTooltipComponent.create((FormattedCharSequence)Component.translatable((String)Translations.Tips.LOCOMOTIVE_SLOT_TICKET).getVisualOrderText())));
        this.addSlot(slotTicket);
        this.addSlot(new UnmodifiableSlot((Container)locomotive, ((Locomotive)locomotive).getContainerSize() - 1, 134, guiHeight - 111));
        this.addSlots(locomotive);
        this.addInventorySlots(playerInv, guiHeight);
    }

    protected void addSlots(T locomotive) {
    }

    public T getLocomotive() {
        return this.locomotive;
    }

    @Override
    public boolean stillValid(Player player) {
        return true;
    }
}

