/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import mods.railcraft.gui.widget.Widget;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.RoutingTableBookItem;
import mods.railcraft.world.level.block.entity.SwitchTrackRouterBlockEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class SwitchTrackRouterMenu
extends RailcraftMenu {
    private final Widget error;
    private final SwitchTrackRouterBlockEntity switchTrackRouter;

    public SwitchTrackRouterMenu(int id, Inventory inventory, SwitchTrackRouterBlockEntity blockEntity) {
        super((MenuType)RailcraftMenuTypes.SWITCH_TRACK_ROUTER.get(), id, inventory.player, blockEntity::isStillValid);
        this.switchTrackRouter = blockEntity;
        Slot routingTableBookSlot = new Slot(this.switchTrackRouter, 0, 35, 24){

            public boolean mayPlace(ItemStack stack) {
                return RoutingTableBookItem.FILTER.test(stack) && stack.getCount() == 1;
            }

            public boolean mayPickup(Player player) {
                return SwitchTrackRouterMenu.this.switchTrackRouter.canAccess(player.nameAndId());
            }

            public boolean allowModification(Player player) {
                if (SwitchTrackRouterMenu.this.switchTrackRouter.canAccess(player.nameAndId())) {
                    return super.allowModification(player);
                }
                return false;
            }

            public void setChanged() {
                super.setChanged();
                SwitchTrackRouterMenu.this.switchTrackRouter.resetLogic();
                SwitchTrackRouterMenu.this.error.hidden = SwitchTrackRouterMenu.this.switchTrackRouter.logicError().isEmpty();
            }
        };
        this.error = new Widget(16, 24, 176, 0, 16, 16);
        this.addWidget(this.error);
        this.addSlot(routingTableBookSlot);
        this.addInventorySlots(inventory, 160);
    }

    public SwitchTrackRouterBlockEntity getSwitchTrackRouter() {
        return this.switchTrackRouter;
    }

    public Widget getErrorWidget() {
        return this.error;
    }
}

