/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory.slot;

import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RailcraftSlot
extends Slot {
    @Nullable
    protected List<ClientTooltipComponent> tooltip;
    private boolean phantom;
    protected boolean canAdjustPhantom = true;
    protected boolean canShift = true;
    protected int stackLimit = -1;
    public BooleanSupplier enabled = () -> true;

    public RailcraftSlot(Container container, int index, int x, int y) {
        super(container, index, x, y);
    }

    public boolean mayPlace(ItemStack stack) {
        return this.enabled.getAsBoolean() && this.container.canPlaceItem(this.getSlotIndex(), stack);
    }

    public RailcraftSlot setEnableCheck(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nullable
    public List<ClientTooltipComponent> getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(@Nullable List<ClientTooltipComponent> tooltip) {
        this.tooltip = tooltip;
    }

    public RailcraftSlot setPhantom() {
        this.phantom = true;
        return this;
    }

    public RailcraftSlot blockShift() {
        this.canShift = false;
        return this;
    }

    public RailcraftSlot setCanAdjustPhantom(boolean canAdjust) {
        this.canAdjustPhantom = canAdjust;
        return this;
    }

    public RailcraftSlot setCanShift(boolean canShift) {
        this.canShift = canShift;
        return this;
    }

    public RailcraftSlot setStackLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    public final int getMaxStackSize() {
        int max = super.getMaxStackSize();
        return this.stackLimit < 0 ? max : Math.min(max, this.stackLimit);
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public boolean canAdjustPhantom() {
        return this.canAdjustPhantom;
    }

    public boolean mayPickup(Player player) {
        return !this.isPhantom();
    }

    public boolean canShift() {
        return this.canShift;
    }
}

