/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.concurrent.atomic.AtomicReference;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.RefinedFirestoneItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.CommonHooks;

public class CrackedFirestoneItem
extends RefinedFirestoneItem {
    public CrackedFirestoneItem(Item.Properties properties) {
        super(100, true, properties);
    }

    public static ItemStack getItemEmpty() {
        ItemStack itemStack = ((CrackedFirestoneItem)((Object)RailcraftItems.CRACKED_FIRESTONE.get())).getDefaultInstance();
        itemStack.setDamageValue(4999);
        return itemStack;
    }

    @Override
    public ItemStack getCraftingRemainder(ItemStack itemStack) {
        double damageLevel = (double)itemStack.getDamageValue() / (double)itemStack.getMaxDamage();
        if (this.random.nextDouble() < damageLevel * 1.0E-4) {
            return ((FirestoneItem)((Object)RailcraftItems.RAW_FIRESTONE.get())).getDefaultInstance();
        }
        AtomicReference<ItemStack> newStack = new AtomicReference<ItemStack>(itemStack.copyWithCount(1));
        Player player = CommonHooks.getCraftingPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            newStack.get().hurtAndBreak(1, serverPlayer.level(), serverPlayer, __ -> newStack.set(ItemStack.EMPTY));
        }
        return newStack.get();
    }
}

