/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.world.entity.FirestoneItemEntity;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirestoneItem
extends Item {
    private final boolean spawnsFire;

    public FirestoneItem(boolean spawnsFire, Item.Properties properties) {
        super(properties);
        this.spawnsFire = spawnsFire;
    }

    public boolean spawnsFire() {
        return this.spawnsFire;
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    @NotNull
    public FirestoneItemEntity createEntity(Level level, Entity entity, ItemStack itemStack) {
        return FirestoneItem.createEntityItem(level, entity, itemStack);
    }

    public boolean isCombineRepairable(ItemStack stack) {
        return false;
    }

    public void fillItemCategory(CreativeModeTab.Output output) {
        output.accept(new ItemStack((ItemLike)this));
        ItemStack item = new ItemStack((ItemLike)this);
        if (item.isDamageableItem()) {
            item.setDamageValue(item.getMaxDamage() - 1);
            output.accept(item);
        }
    }

    @NotNull
    public static FirestoneItemEntity createEntityItem(Level level, Entity entity, ItemStack itemStack) {
        FirestoneItemEntity firestone = new FirestoneItemEntity(level, entity.position(), itemStack);
        firestone.setThrower(entity);
        firestone.setDeltaMovement(entity.getDeltaMovement());
        firestone.setDefaultPickUpDelay();
        return firestone;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (this.spawnsFire && level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK) && entity instanceof Player) {
            Player player = (Player)entity;
            if (level.getRandom().nextInt(12) % 4 == 0) {
                FirestoneItem.trySpawnFire(level, player.blockPosition(), stack, (Entity)player);
            }
        }
    }

    public static boolean trySpawnFire(ServerLevel level, BlockPos pos, ItemStack stack, Entity entity) {
        boolean spawnedFire = false;
        for (int i = 0; i < stack.getCount(); ++i) {
            spawnedFire |= FirestoneItem.spawnFire((Level)level, pos);
        }
        if (spawnedFire && stack.isDamageableItem() && stack.getDamageValue() < stack.getMaxDamage() - 1 && entity instanceof Player) {
            Player player = (Player)entity;
            stack.hurtAndBreak(1, level, (LivingEntity)player, __ -> {});
        }
        return spawnedFire;
    }

    public static boolean spawnFire(Level level, BlockPos pos) {
        RandomSource random = level.getRandom();
        int x = pos.getX() - 5 + random.nextInt(12);
        int y = pos.getY() + random.nextInt(12);
        int z = pos.getZ() - 5 + random.nextInt(12);
        y = Mth.clamp((int)y, (int)(level.getMinY() + 2), (int)(level.getMaxY() - 1));
        BlockPos firePos = new BlockPos(x, y, z);
        BlockState blockState = BaseFireBlock.getState((BlockGetter)level, (BlockPos)firePos);
        return level.getBlockState(firePos).isAir() && blockState.canSurvive((LevelReader)level, firePos) && level.setBlockAndUpdate(firePos, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        if (stack.is((Item)RailcraftItems.RAW_FIRESTONE.get())) {
            tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.RAW_FIRESTONE).withStyle(ChatFormatting.GRAY));
        } else if (stack.is((Item)RailcraftItems.CUT_FIRESTONE.get())) {
            tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.CUT_FIRESTONE).withStyle(ChatFormatting.GRAY));
        }
    }
}

