/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.function.Consumer;
import mods.railcraft.Translations;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class FirestoneOreBlockItem
extends BlockItem {
    public FirestoneOreBlockItem(Item.Properties properties) {
        super((Block)RailcraftBlocks.FIRESTONE_ORE.get(), properties);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK) && entity instanceof Player) {
            Player player = (Player)entity;
            if (level.getRandom().nextInt(12) % 4 == 0) {
                FirestoneItem.trySpawnFire(level, player.blockPosition(), stack, (Entity)player);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)Translations.Tips.FIRESTONE_ORE).withStyle(ChatFormatting.GRAY));
    }
}

